/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol;

import java.io.PrintStream;
import junit.framework.TestCase;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.protocol.JProtocol;
import org.jnetpcap.protocol.tcpip.Udp;
import org.jnetpcap.protocol.voip.Rtp;
import org.junit.Test;

public class TestRTP
extends TestCase {
    private final PrintStream out = System.out;
    private static final String FILE = "tests/test-sip-rtp.pcap";

    @Test
    public void testRTP() {
        boolean bl = false;
        for (PcapPacket pcapPacket : TestUtils.getIterable(FILE)) {
            if (!pcapPacket.hasHeader(Rtp.ID)) continue;
            bl = true;
            this.out.println(pcapPacket.getState().toDebugString());
            this.out.printf("#%d - RTP%n", pcapPacket.getFrameNumber());
        }
        TestCase.assertTrue((String)"RTP not found", (boolean)bl);
    }

    @Test
    public void testRTCP() {
        long l = JProtocol.createMaskFromIds(49, 50, 51, 53, 52);
        boolean bl = false;
        JPacket.getDefaultScanner().setFrameNumber(1L);
        for (PcapPacket pcapPacket : TestUtils.getIterable(FILE)) {
            int n = JProtocol.maskToGroup(l);
            this.out.printf("group=%d mask=0x%016X map=%016X%n", n, l, pcapPacket.getState().get64BitHeaderMap(n));
            if (pcapPacket.hasHeader(5)) {
                this.out.println(pcapPacket.getHeader(new Udp()));
            }
            this.out.println(pcapPacket.getState().toDebugString());
            if (pcapPacket.hasAnyHeader(l)) {
                bl = true;
                this.out.println(pcapPacket);
                this.out.printf("#%d - RTCP%n", pcapPacket.getFrameNumber());
                break;
            }
            if (pcapPacket.getFrameNumber() != 634L) continue;
            break;
        }
        TestCase.assertTrue((String)"RTCP not found", (boolean)bl);
    }

    public void testProtocolBitmaskCombine() {
        long l = JProtocol.createMaskFromIds(49, 50, 51, 53, 52);
        long l2 = JProtocol.createMaskFromProtocols(JProtocol.RTCP_SENDER_REPORT, JProtocol.RTCP_RECEIVER_REPORT, JProtocol.RTCP_BYE, JProtocol.RTCP_SDES, JProtocol.RTCP_APP);
        TestCase.assertEquals((long)l, (long)l2);
    }
}

