/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.header;

import java.io.IOException;
import junit.framework.TestCase;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.TextFormatter;
import org.jnetpcap.protocol.network.Ip4;

public class TestSubHeader
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSubHeaderAccess() throws IOException {
        Ip4 ip4 = new Ip4();
        Ip4.Timestamp timestamp = new Ip4.Timestamp();
        Ip4.LooseSourceRoute looseSourceRoute = new Ip4.LooseSourceRoute();
        Ip4.StrictSourceRoute strictSourceRoute = new Ip4.StrictSourceRoute();
        Ip4.RecordRoute recordRoute = new Ip4.RecordRoute();
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-icmp-recordroute-opt.pcap", 0);
        TextFormatter textFormatter = new TextFormatter();
        textFormatter.format(pcapPacket);
        System.out.println(pcapPacket.getState().toDebugString());
        TestSubHeader.assertNotNull((Object)pcapPacket);
        TestSubHeader.assertTrue((boolean)pcapPacket.hasHeader(ip4));
        TestSubHeader.assertTrue((boolean)ip4.hasSubHeaders());
        TestSubHeader.assertFalse((boolean)ip4.hasSubHeader(looseSourceRoute));
        TestSubHeader.assertFalse((boolean)ip4.hasSubHeader(strictSourceRoute));
        TestSubHeader.assertFalse((boolean)ip4.hasSubHeader(timestamp));
        TestSubHeader.assertTrue((boolean)ip4.hasSubHeader(recordRoute));
        TestSubHeader.assertEquals((int)9, (int)recordRoute.addressCount());
        byte[] byArray = recordRoute.address(0);
        TestSubHeader.assertNotNull((Object)byArray);
        TestSubHeader.assertEquals((int)4, (int)byArray.length);
        TestSubHeader.assertEquals((int)-64, (int)byArray[0]);
        TestSubHeader.assertEquals((int)-88, (int)byArray[1]);
        TestSubHeader.assertEquals((int)1, (int)byArray[2]);
        TestSubHeader.assertEquals((int)13, (int)byArray[3]);
        TestSubHeader.assertNotNull((Object)pcapPacket);
        TestSubHeader.assertTrue((boolean)pcapPacket.hasHeader(ip4));
        TestSubHeader.assertTrue((boolean)ip4.hasSubHeaders());
        TestSubHeader.assertFalse((boolean)ip4.hasSubHeader(looseSourceRoute));
        TestSubHeader.assertFalse((boolean)ip4.hasSubHeader(strictSourceRoute));
        TestSubHeader.assertFalse((boolean)ip4.hasSubHeader(timestamp));
        TestSubHeader.assertTrue((boolean)ip4.hasSubHeader(recordRoute));
        TestSubHeader.assertEquals((int)9, (int)recordRoute.addressCount());
        byArray = recordRoute.address(0);
        TestSubHeader.assertNotNull((Object)byArray);
        TestSubHeader.assertEquals((int)4, (int)byArray.length);
        TestSubHeader.assertEquals((int)-64, (int)byArray[0]);
        TestSubHeader.assertEquals((int)-88, (int)byArray[1]);
        TestSubHeader.assertEquals((int)1, (int)byArray[2]);
        TestSubHeader.assertEquals((int)13, (int)byArray[3]);
    }

    public void testSyntaxText() {
        Ip4 ip4 = new Ip4();
        Ip4.Timestamp timestamp = new Ip4.Timestamp();
        Ip4.LooseSourceRoute looseSourceRoute = new Ip4.LooseSourceRoute();
        Ip4.StrictSourceRoute strictSourceRoute = new Ip4.StrictSourceRoute();
        Ip4.RecordRoute recordRoute = new Ip4.RecordRoute();
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-icmp-recordroute-opt.pcap", 0);
        if (pcapPacket.hasHeader(ip4) && ip4.hasSubHeaders()) {
            if (ip4.hasSubHeader(looseSourceRoute)) {
                System.out.println("LooseSource");
            }
            if (ip4.hasSubHeader(strictSourceRoute)) {
                System.out.println("StrictSource");
            }
            if (ip4.hasSubHeader(timestamp)) {
                System.out.println("Timestamp");
            }
            if (ip4.hasSubHeader(recordRoute)) {
                System.out.println("RecordRoute");
            }
        }
    }

    public void test1() throws IOException {
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-icmp-recordroute-opt.pcap", 0);
        TestSubHeader.assertNotNull((Object)pcapPacket);
        TextFormatter textFormatter = new TextFormatter(System.out);
        textFormatter.format(pcapPacket);
        System.out.println(pcapPacket.toString());
        System.out.println(pcapPacket.getState().toHexdump());
        System.out.println(pcapPacket.getState().toDebugString());
    }
}

