/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.header;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.TextFormatter;
import org.jnetpcap.protocol.application.Html;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.tcpip.Http;
import org.jnetpcap.util.JLogger;
import org.jnetpcap.util.config.JConfig;
import org.jnetpcap.util.resolver.Resolver;

public class TestHttp
extends TestCase {
    private static final Appendable OUT = System.out;
    private Http http = new Http();

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegistration() {
        TestHttp.assertTrue((JRegistry.lookupId(Http.class) > 12 ? 1 : 0) != 0);
    }

    public void testHttpFormattingWithResolveAddressDisabled() throws IOException {
        TextFormatter textFormatter = new TextFormatter(OUT);
        textFormatter.setResolveAddresses(false);
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        Ip4 ip4 = new Ip4();
        Ethernet ethernet = new Ethernet();
        if (pcapPacket.hasHeader(ethernet)) {
            textFormatter.format(ethernet);
        }
        if (pcapPacket.hasHeader(ip4)) {
            textFormatter.format(ip4);
            textFormatter.format(ip4);
        }
        textFormatter.format(pcapPacket);
        Html html = new Html();
        TestHttp.assertTrue((String)"html header not found", (boolean)pcapPacket.hasHeader(html));
        System.out.printf("link related tags=%s\n", Arrays.asList(html.links()).toString());
    }

    public void testHttpFormattingWithResolveAddressEnabled() throws IOException {
        JLogger.getLogger(JConfig.class).setLevel(Level.FINE);
        JLogger.getLogger(Resolver.class.getPackage()).setLevel(Level.FINER);
        TextFormatter textFormatter = new TextFormatter(OUT);
        textFormatter.setResolveAddresses(true);
        PcapPacket pcapPacket = TestUtils.getPcapPacket("tests/test-http-jpeg.pcap", 5);
        Ip4 ip4 = new Ip4();
        Ethernet ethernet = new Ethernet();
        if (pcapPacket.hasHeader(ethernet)) {
            textFormatter.format(ethernet);
        }
        if (pcapPacket.hasHeader(ip4)) {
            textFormatter.format(ip4);
            System.out.println();
        }
        JRegistry.shutdown();
    }
}

