/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapUtils;

public class TestPcapUtils
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetMacAddresses() throws IOException {
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        StringBuilder stringBuilder = new StringBuilder();
        Pcap.findAllDevs(arrayList, stringBuilder);
        for (PcapIf pcapIf : arrayList) {
            byte[] byArray = PcapUtils.getHardwareAddress(pcapIf);
            if (byArray == null) {
                System.out.printf("%s=%s\n", pcapIf.getName(), "NOT FOUND");
                continue;
            }
            System.out.printf("%s=%s\n", pcapIf.getName(), TestPcapUtils.asString(byArray));
        }
    }

    private static String asString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : byArray) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(':');
            }
            if (n >= 0 && n < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n < 0 ? n + 256 : n).toUpperCase());
        }
        return stringBuilder.toString();
    }
}

