/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.util;

import de.gematik.rbellogger.RbelOptions;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelMultiMap;
import de.gematik.rbellogger.util.RbelAnsiColors;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RbelElementTreePrinter {
    private final RbelElement rootElement;
    private final int maximumLevels;
    private final boolean printContent;
    private final boolean printKeys;
    private final boolean printFacets;
    private final boolean printColors;

    public String execute() {
        RbelElement position = new RbelElement(null, null);
        position.addFacet(() -> new RbelMultiMap().with(this.findKeyOfRootElement(), this.rootElement));
        return this.executeRecursive(position, "", Math.max(this.maximumLevels, this.maximumLevels + 1));
    }

    private String findKeyOfRootElement() {
        return Optional.ofNullable(this.rootElement.getParentNode()).map(RbelElement::getChildNodesWithKey).stream().flatMap(RbelMultiMap::stream).filter(pair -> pair.getValue() == this.rootElement).map(Map.Entry::getKey).findFirst().orElse("");
    }

    private String executeRecursive(RbelElement position, String padding, int remainingLevels) {
        if (remainingLevels <= 0) {
            return "";
        }
        Object result = "";
        Iterator<Map.Entry<String, RbelElement>> iterator = position.getChildNodesWithKey().iterator();
        while (iterator.hasNext()) {
            String padString;
            String switchString;
            Map.Entry<String, RbelElement> childNode = iterator.next();
            if (iterator.hasNext()) {
                switchString = "\u251c\u2500\u2500";
                padString = "|  ";
            } else {
                switchString = "\u2514\u2500\u2500";
                padString = "   ";
            }
            result = (String)result + this.cl(RbelAnsiColors.YELLOW_BRIGHT) + padding + switchString + this.cl(RbelAnsiColors.RESET);
            result = (String)result + this.cl(RbelAnsiColors.RED_BOLD) + childNode.getKey() + this.cl(RbelAnsiColors.RESET);
            result = (String)result + this.printContentOf(childNode.getValue());
            result = (String)result + this.printFacets(childNode.getValue());
            result = (String)result + "\n";
            if (childNode.getValue().getChildNodes().isEmpty()) continue;
            result = (String)result + this.executeRecursive(childNode.getValue(), padding + padString, remainingLevels - 1);
        }
        return result;
    }

    private String printFacets(RbelElement value) {
        if (!RbelOptions.ACTIVATE_FACETS_PRINTING) {
            return "";
        }
        String facetsString = value.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).filter(s2 -> !"RbelRootFacet".equals(s2)).filter(s2 -> !"RbelListFacet".equals(s2)).filter(s2 -> !"RbelNestedFacet".equals(s2)).filter(s2 -> !"RbelMapFacet".equals(s2)).collect(Collectors.joining(","));
        if (StringUtils.isEmpty(facetsString)) {
            return "";
        }
        return this.cl(RbelAnsiColors.CYAN) + " (" + facetsString + ")" + this.cl(RbelAnsiColors.RESET);
    }

    private String printKeyOf(RbelElement value) {
        if (!this.printKeys) {
            return "";
        }
        return " " + this.cl(RbelAnsiColors.GREEN) + "[$." + value.findNodePath() + "]" + this.cl(RbelAnsiColors.RESET);
    }

    private String printContentOf(RbelElement value) {
        if (!this.printContent) {
            return "";
        }
        String content = value.getRawStringContent();
        if (content == null) {
            content = value.seekValue().map(Object::toString).map(strValue -> "Value: " + strValue).orElse("<null>");
        }
        if (content == null) {
            return "";
        }
        return " (" + this.cl(RbelAnsiColors.BLUE) + StringUtils.substring(content.replace("\n", "\\n").replace("\r", "\\r"), 0, RbelOptions.RBEL_PATH_TREE_VIEW_VALUE_OUTPUT_LENGTH) + (content.length() > RbelOptions.RBEL_PATH_TREE_VIEW_VALUE_OUTPUT_LENGTH ? "..." : "") + this.cl(RbelAnsiColors.RESET) + ")";
    }

    private String cl(RbelAnsiColors color) {
        if (this.printColors) {
            return color.toString();
        }
        return "";
    }

    @Generated
    private static int $default$maximumLevels() {
        return Integer.MAX_VALUE;
    }

    @Generated
    private static boolean $default$printContent() {
        return true;
    }

    @Generated
    private static boolean $default$printKeys() {
        return false;
    }

    @Generated
    private static boolean $default$printFacets() {
        return true;
    }

    @Generated
    private static boolean $default$printColors() {
        return true;
    }

    @Generated
    public static RbelElementTreePrinterBuilder builder() {
        return new RbelElementTreePrinterBuilder();
    }

    @ConstructorProperties(value={"rootElement", "maximumLevels", "printContent", "printKeys", "printFacets", "printColors"})
    @Generated
    private RbelElementTreePrinter(RbelElement rootElement, int maximumLevels, boolean printContent, boolean printKeys, boolean printFacets, boolean printColors) {
        this.rootElement = rootElement;
        this.maximumLevels = maximumLevels;
        this.printContent = printContent;
        this.printKeys = printKeys;
        this.printFacets = printFacets;
        this.printColors = printColors;
    }

    @Generated
    public static class RbelElementTreePrinterBuilder {
        @Generated
        private RbelElement rootElement;
        @Generated
        private boolean maximumLevels$set;
        @Generated
        private int maximumLevels$value;
        @Generated
        private boolean printContent$set;
        @Generated
        private boolean printContent$value;
        @Generated
        private boolean printKeys$set;
        @Generated
        private boolean printKeys$value;
        @Generated
        private boolean printFacets$set;
        @Generated
        private boolean printFacets$value;
        @Generated
        private boolean printColors$set;
        @Generated
        private boolean printColors$value;

        @Generated
        RbelElementTreePrinterBuilder() {
        }

        @Generated
        public RbelElementTreePrinterBuilder rootElement(RbelElement rootElement) {
            this.rootElement = rootElement;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder maximumLevels(int maximumLevels) {
            this.maximumLevels$value = maximumLevels;
            this.maximumLevels$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printContent(boolean printContent) {
            this.printContent$value = printContent;
            this.printContent$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printKeys(boolean printKeys) {
            this.printKeys$value = printKeys;
            this.printKeys$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printFacets(boolean printFacets) {
            this.printFacets$value = printFacets;
            this.printFacets$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinterBuilder printColors(boolean printColors) {
            this.printColors$value = printColors;
            this.printColors$set = true;
            return this;
        }

        @Generated
        public RbelElementTreePrinter build() {
            int maximumLevels$value = this.maximumLevels$value;
            if (!this.maximumLevels$set) {
                maximumLevels$value = RbelElementTreePrinter.$default$maximumLevels();
            }
            boolean printContent$value = this.printContent$value;
            if (!this.printContent$set) {
                printContent$value = RbelElementTreePrinter.$default$printContent();
            }
            boolean printKeys$value = this.printKeys$value;
            if (!this.printKeys$set) {
                printKeys$value = RbelElementTreePrinter.$default$printKeys();
            }
            boolean printFacets$value = this.printFacets$value;
            if (!this.printFacets$set) {
                printFacets$value = RbelElementTreePrinter.$default$printFacets();
            }
            boolean printColors$value = this.printColors$value;
            if (!this.printColors$set) {
                printColors$value = RbelElementTreePrinter.$default$printColors();
            }
            return new RbelElementTreePrinter(this.rootElement, maximumLevels$value, printContent$value, printKeys$value, printFacets$value, printColors$value);
        }

        @Generated
        public String toString() {
            return "RbelElementTreePrinter.RbelElementTreePrinterBuilder(rootElement=" + this.rootElement + ", maximumLevels$value=" + this.maximumLevels$value + ", printContent$value=" + this.printContent$value + ", printKeys$value=" + this.printKeys$value + ", printFacets$value=" + this.printFacets$value + ", printColors$value=" + this.printColors$value + ")";
        }
    }
}

