/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.util.CryptoLoader;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelX5cKeyReader
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelX5cKeyReader.class);

    @Override
    public void consumeElement(RbelElement rbelElement, RbelConverter converter) {
        List elementList = rbelElement.getAll("x5c").stream().filter(el -> el.hasFacet(RbelJsonFacet.class)).collect(Collectors.toList());
        for (RbelElement x5cElement : elementList) {
            Optional<byte[]> certificateData = this.getX509Certificate(x5cElement);
            Optional<String> keyId = this.getKeyId(x5cElement);
            if (!keyId.isPresent() || !certificateData.isPresent()) continue;
            try {
                X509Certificate certificate = CryptoLoader.getCertificateFromPem(certificateData.get());
                converter.getRbelKeyManager().addKey(keyId.get(), certificate.getPublicKey(), 100);
                log.info("Added new key from JKS ({})", (Object)keyId.get());
            }
            catch (Exception e) {
                log.warn("Exception while extracting X5C", e);
            }
        }
    }

    private Optional<String> getKeyId(RbelElement x5cElement) {
        return Optional.ofNullable(x5cElement.getParentNode()).flatMap(el -> el.getFirst("kid")).flatMap(el -> el.getFirst("content")).map(RbelElement::getRawStringContent);
    }

    private Optional<byte[]> getX509Certificate(RbelElement x5cElement) {
        return x5cElement.getFirst("0").flatMap(el -> el.getFirst("content")).map(RbelElement::getRawStringContent).map(Base64.getDecoder()::decode);
    }
}

