/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJweEncryptionInfo;
import de.gematik.rbellogger.data.facet.RbelJweFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.key.RbelKey;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.lang.JoseException;

public class RbelJweConverter
implements RbelConverterPlugin {
    @Override
    public void consumeElement(RbelElement rbel, RbelConverter context) {
        Optional<JsonWebEncryption> jweOptional = this.initializeJwe(rbel);
        if (jweOptional.isEmpty()) {
            return;
        }
        JsonWebEncryption jwe = jweOptional.get();
        Optional<Pair<String, String>> correctKeyAndPayload = this.findCorrectKeyAndReturnPayload(context, jwe);
        RbelJweFacet jweFacet = correctKeyAndPayload.isEmpty() ? RbelJweFacet.builder().header(context.convertElement(jwe.getHeaders().getFullHeaderAsJsonString(), rbel)).body(context.convertElement("<Encrypted Payload>", rbel)).encryptionInfo(this.buildEncryptionInfo(false, null, rbel)).build() : RbelJweFacet.builder().header(context.convertElement(jwe.getHeaders().getFullHeaderAsJsonString(), rbel)).body(context.convertElement(correctKeyAndPayload.get().getValue(), rbel)).encryptionInfo(this.buildEncryptionInfo(true, correctKeyAndPayload.get().getKey(), rbel)).build();
        rbel.addFacet(jweFacet);
        rbel.addFacet(new RbelRootFacet<RbelJweFacet>(jweFacet));
    }

    private RbelElement buildEncryptionInfo(boolean decryptable, String keyId, RbelElement jweElement) {
        RbelElement encryptionInfoElement = RbelElement.builder().parentNode(jweElement).rawContent(null).build();
        encryptionInfoElement.addFacet(RbelJweEncryptionInfo.builder().wasDecryptable(RbelElement.wrap(null, encryptionInfoElement, decryptable)).decryptedUsingKeyWithId(RbelElement.wrap(null, encryptionInfoElement, keyId)).build());
        return encryptionInfoElement;
    }

    private Optional<Pair<String, String>> findCorrectKeyAndReturnPayload(RbelConverter context, JsonWebEncryption jwe) {
        for (RbelKey keyEntry : context.getRbelKeyManager().getAllKeys().collect(Collectors.toList())) {
            try {
                jwe.setKey(keyEntry.getKey());
                return Optional.of(Pair.of(keyEntry.getKeyName(), jwe.getPayload()));
            }
            catch (Exception e) {
            }
        }
        return Optional.empty();
    }

    private Optional<JsonWebEncryption> initializeJwe(RbelElement rbel) {
        JsonWebEncryption receiverJwe = new JsonWebEncryption();
        receiverJwe.setDoKeyValidation(false);
        receiverJwe.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        try {
            receiverJwe.setCompactSerialization(rbel.getRawStringContent());
            receiverJwe.getHeaders();
            return Optional.ofNullable(receiverJwe);
        }
        catch (JoseException e) {
            return Optional.empty();
        }
    }

    static {
        BrainpoolCurves.init();
    }
}

