/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelJsonConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelBase64Facet;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;

public class RbelBase64JsonConverter
extends RbelJsonConverter {
    @Override
    public void consumeElement(RbelElement rbel, RbelConverter context) {
        if (rbel.getRawStringContent().isEmpty()) {
            return;
        }
        this.safeConvertBase64Using(rbel.getRawStringContent(), Base64.getDecoder(), context, rbel).or(() -> this.safeConvertBase64Using(rbel.getRawStringContent(), Base64.getUrlDecoder(), context, rbel)).ifPresent(rbel::addFacet);
    }

    private Optional<RbelBase64Facet> safeConvertBase64Using(String input, Base64.Decoder decoder, RbelConverter context, RbelElement parentNode) {
        return Optional.ofNullable(input).map(i -> {
            try {
                return decoder.decode((String)i);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).map(data -> new RbelElement((byte[])data, parentNode)).stream().peek(innerNode -> context.convertElement((RbelElement)innerNode)).filter(innerNode -> innerNode.hasFacet(RbelRootFacet.class)).filter(innerNode -> innerNode.getFacetOrFail(RbelRootFacet.class).getRootFacet() instanceof RbelJsonFacet || innerNode.getFacetOrFail(RbelRootFacet.class).getRootFacet() instanceof RbelXmlFacet).map(child -> new RbelBase64Facet((RbelElement)child)).findAny();
    }
}

