/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Level;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.util.JLogger;
import org.jnetpcap.util.config.JConfig;
import org.jnetpcap.util.resolver.AbstractResolver;

public class IEEEOuiPrefixResolver
extends AbstractResolver {
    public static final String IEEE_OUI_DATABASE_PATH = "http://standards.ieee.org/regauth/oui/oui.txt";
    private static final String RESOURCE_COMPRESSED_OUI_DATABASE = "oui.txt";
    private static final String PROPERTY_OUI_DB_URL = "resolver.OUI_PREFIX.db.url";
    private static final String PROPERTY_OUI_DB_DOWNLOAD = "resolver.OUI_PREFIX.db.download";
    private static final String DEFAULT_OUI_DB_DOWNLOAD = "false";
    private boolean initialized = false;

    public IEEEOuiPrefixResolver() {
        super(JLogger.getLogger(IEEEOuiPrefixResolver.class), "OUI_PREFIX");
    }

    public void initializeIfNeeded() {
        if (!this.initialized && !this.hasCacheFile()) {
            this.initialized = true;
            this.setCacheCapacity(13000);
            super.initializeIfNeeded();
            this.setPositiveTimeout(157680000000L);
            this.setNegativeTimeout(0L);
            try {
                URL uRL = JConfig.getResourceURL(RESOURCE_COMPRESSED_OUI_DATABASE);
                if (uRL != null) {
                    this.logger.fine("loading compressed database file from " + uRL.toString());
                    this.readOuisFromCompressedIEEEDb(RESOURCE_COMPRESSED_OUI_DATABASE);
                    return;
                }
                boolean bl = Boolean.parseBoolean(JConfig.getProperty(PROPERTY_OUI_DB_DOWNLOAD, DEFAULT_OUI_DB_DOWNLOAD));
                String string = JConfig.getProperty(PROPERTY_OUI_DB_URL);
                if (string != null && bl) {
                    uRL = new URL(string);
                    this.logger.fine("loading remote database " + uRL.toString());
                    this.loadCache(uRL);
                    return;
                }
            }
            catch (IOException iOException) {
                this.logger.log(Level.WARNING, "error while reading database", iOException);
            }
        } else {
            super.initializeIfNeeded();
        }
    }

    public int loadCache(URL uRL) throws IOException {
        if (uRL == null) {
            uRL = new URL(IEEE_OUI_DATABASE_PATH);
        }
        return this.readOuisFromRawIEEEDb(new BufferedReader(new InputStreamReader(uRL.openStream())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readOuisFromCompressedIEEEDb(BufferedReader bufferedReader) throws IOException {
        int n = 0;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray = string.split(":", 2);
                if (stringArray.length < 2) continue;
                Long l = Long.parseLong(stringArray[0], 16);
                super.addToCache(l, stringArray[1]);
                ++n;
            }
        }
        finally {
            bufferedReader.close();
        }
        return n;
    }

    private boolean readOuisFromCompressedIEEEDb(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        if (file.canRead()) {
            this.readOuisFromCompressedIEEEDb(new BufferedReader(new FileReader(file)));
            return true;
        }
        InputStream inputStream = JFormatter.class.getClassLoader().getResourceAsStream("resources/" + string);
        if (inputStream == null) {
            return false;
        }
        this.readOuisFromCompressedIEEEDb(new BufferedReader(new InputStreamReader(inputStream)));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readOuisFromRawIEEEDb(BufferedReader bufferedReader) throws IOException {
        int n = 0;
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (!string.contains("(base 16)") || (stringArray = string.split("\t\t")).length < 2) continue;
                String string2 = stringArray[0].split(" ")[0];
                long l = Long.parseLong(string2, 16);
                String[] stringArray2 = stringArray[1].split(" ");
                if (stringArray2.length <= 1) continue;
                String string3 = stringArray2[0];
                if (string3.length() <= 3 || string3.length() == 2 && string3.charAt(1) == '.') {
                    string3 = string3 + stringArray2[1];
                }
                string3 = string3.replace('.', '_');
                string3 = string3.replace('-', '_');
                string3 = string3.replace('\t', ' ').trim();
                if ((string3 = string3.replace(',', ' ').trim()).endsWith("_") || string3.endsWith("-")) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                string3 = this.transform(string3, stringArray2);
                super.addToCache(l, string3);
                ++n;
            }
        }
        finally {
            bufferedReader.close();
        }
        return n;
    }

    private String transform(String string, String[] stringArray) {
        String string2;
        String string3;
        int n = 1;
        while ((string3 = this.transform(string, string2 = stringArray.length > 1 ? stringArray[n] : null)) != string) {
            string = string3;
        }
        return string;
    }

    private String transform(String string, String string2) {
        string = this.transform(string, string2, "Graphic", "Graph");
        string = this.transform(string, string2, "Electronic", "Elect");
        string = this.transform(string, string2, "Application", "App");
        string = this.transform(string, string2, "Incorporated", "Inc");
        string = this.transform(string, string2, "Corporation", "Corp");
        string = this.transform(string, string2, "Company", "Co");
        string = this.transform(string, string2, "Technologies", "Tech");
        string = this.transform(string, string2, "Technology", "Tech");
        string = this.transform(string, string2, "Communication", "Com");
        string = this.transform(string, string2, "Network", "Net");
        string = this.transform(string, string2, "System", "Sys");
        string = this.transform(string, string2, "Information", "Info");
        string = this.transform(string, string2, "Industries", "Ind");
        string = this.transform(string, string2, "Industrial", "Ind");
        string = this.transform(string, string2, "Industry", "Ind");
        string = this.transform(string, string2, "Laboratories", "Lab");
        string = this.transform(string, string2, "Laboratory", "Ind");
        string = this.transform(string, string2, "Enterprises", "Ent");
        string = this.transform(string, string2, "Computer", "Cp");
        string = this.transform(string, string2, "Manufacturing", "Mfg");
        string = this.transform(string, string2, "Resources", "Res");
        string = this.transform(string, string2, "Resource", "Res");
        string = this.transform(string, string2, "Limited", "Ltd");
        string = this.transform(string, string2, "International", "Int");
        string = this.transform(string, string2, "Presentation", "Pres");
        string = this.transform(string, string2, "Equipment", "Eq");
        string = this.transform(string, string2, "Peripheral", "Pr");
        string = this.transform(string, string2, "Interactive", "Int");
        return string;
    }

    private String transform(String string, String string2, String string3, String string4) {
        String string5 = string3 + "s";
        string = string.replace(string5.toUpperCase(), string4);
        string = string.replace(string5.toLowerCase(), string4);
        string = string.replace(string5, string4);
        string = string.replace(string3.toUpperCase(), string4);
        string = string.replace(string3.toLowerCase(), string4);
        if ((string = string.replace(string3, string4)).equals(string4) && string2 != null) {
            string = string + string2;
        }
        return string;
    }

    public String resolveToName(byte[] byArray, long l) {
        return null;
    }

    public long toHashCode(byte[] byArray) {
        return (byArray[2] < 0 ? byArray[2] + 256 : byArray[2]) | (byArray[1] < 0 ? byArray[1] + 256 : byArray[1]) << 8 | (byArray[0] < 0 ? byArray[0] + 256 : byArray[0]) << 16;
    }

    protected String resolveToName(long l, long l2) {
        throw new UnsupportedOperationException("this resolver only resolves addresses in byte[] form");
    }
}

