/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.voip;

import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.protocol.voip.Rtcp;

@Header(length=4, name="RTCP-BYE", suite=ProtocolSuite.TCP_IP)
public class RtcpBye
extends Rtcp {
    public static final int ID = 52;

    @Field(offset=3, length=5, display="source count")
    public int sc() {
        return (super.getByte(0) & 0x1F) >> 0;
    }

    @Dynamic(field="ssrc", value=Field.Property.LENGTH)
    public int ssrcLength() {
        return this.sc() * 32;
    }

    @Field(offset=32, length=32, format="%x")
    public int[] ssrc() {
        return this.ssrc(new int[this.sc()]);
    }

    public int[] ssrc(int[] nArray) {
        int n = this.sc();
        for (int i = 0; i < n && i < nArray.length; ++i) {
            nArray[i] = super.getInt(4 + i * 4);
        }
        return nArray;
    }

    @Dynamic(field="reason", value=Field.Property.CHECK)
    public boolean hasReason() {
        int n = (super.length() << 2) + 4;
        return n > this.sc() * 4 + 4;
    }

    @Dynamic(field="reason", value=Field.Property.OFFSET)
    public int reasonOffset() {
        return ((this.sc() << 2) + 4) * 8;
    }

    @Dynamic(field="reason", value=Field.Property.LENGTH)
    public int reasonBitLength() {
        return this.reasonLength() * 8;
    }

    public int reasonLength() {
        int n = (this.sc() << 2) + 4;
        return super.getUByte(n);
    }

    @Field
    public String reason() {
        boolean bl;
        if (!this.hasReason()) {
            return "";
        }
        int n = (this.sc() << 2) + 4;
        int n2 = super.getUByte(n);
        boolean bl2 = bl = (n2 & 3) != 0;
        if (bl) {
            return super.getUTF8String(n + 1, 0);
        }
        return super.getUTF8String(n + 1, n2);
    }
}

