/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import com.slytechs.library.JNILibrary;
import com.slytechs.library.Library;
import com.slytechs.library.LibraryInitializer;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.PeeringException;

@Library(jni={"jnetpcap"}, preload={JMemory.class})
public class JBuffer
extends JMemory {
    private volatile boolean order = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private boolean readonly = false;

    @LibraryInitializer
    private static native void initIds();

    public JBuffer(JMemory.Type type) {
        super(type);
    }

    public JBuffer(ByteBuffer byteBuffer) {
        super(byteBuffer);
    }

    public JBuffer(int n) {
        super(n);
    }

    public JBuffer(JMemory jMemory) {
        super(jMemory);
    }

    private final int check(int n, int n2, long l) {
        if (l == 0L) {
            throw new NullPointerException();
        }
        if (n < 0 || n + n2 > this.size) {
            throw new BufferUnderflowException();
        }
        return n;
    }

    public JBuffer(byte[] byArray) {
        super(byArray.length);
        this.setByteArray(0, byArray);
    }

    public byte getByte(int n) {
        return JBuffer.getByte0(this.physical, this.check(n, 1, this.physical));
    }

    private static native byte getByte0(long var0, int var2);

    public byte[] getByteArray(int n, byte[] byArray) {
        return this.getByteArray(n, byArray, 0, byArray.length);
    }

    public byte[] getByteArray(int n, int n2) {
        return this.getByteArray(n, new byte[n2], 0, n2);
    }

    public byte[] getByteArray(int n, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 + n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return JBuffer.getByteArray0(this.physical, this.check(n, n3, this.physical), byArray, byArray.length, n2, n3);
    }

    private static native byte[] getByteArray0(long var0, int var2, byte[] var3, int var4, int var5, int var6);

    public double getDouble(int n) {
        return Double.longBitsToDouble(JBuffer.getLong0(this.physical, this.order, this.check(n, 8, this.physical)));
    }

    private static native double getDouble0(long var0, boolean var2, int var3);

    public float getFloat(int n) {
        return Float.intBitsToFloat(JBuffer.getInt0(this.physical, this.order, this.check(n, 4, this.physical)));
    }

    private static native float getFloat0(long var0, boolean var2, int var3);

    public int getInt(int n) {
        return JBuffer.getInt0(this.physical, this.order, this.check(n, 4, this.physical));
    }

    private static native int getInt0(long var0, boolean var2, int var3);

    public long getLong(int n) {
        return JBuffer.getLong0(this.physical, this.order, this.check(n, 8, this.physical));
    }

    private static native long getLong0(long var0, boolean var2, int var3);

    public short getShort(int n) {
        return JBuffer.getShort0(this.physical, this.order, this.check(n, 2, this.physical));
    }

    private static native short getShort0(long var0, boolean var2, int var3);

    public int getUByte(int n) {
        return JBuffer.getUByte0(this.physical, this.check(n, 1, this.physical));
    }

    private static native int getUByte0(long var0, int var2);

    public long getUInt(int n) {
        return JBuffer.getUInt0(this.physical, this.order, this.check(n, 4, this.physical));
    }

    private static native long getUInt0(long var0, boolean var2, int var3);

    public int getUShort(int n) {
        return JBuffer.getUShort0(this.physical, this.order, this.check(n, 2, this.physical));
    }

    private static native int getUShort0(long var0, boolean var2, int var3);

    public int findUTF8String(int n, char ... cArray) {
        int n2 = this.size();
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            char c = this.getUTF8Char(i);
            char c2 = cArray[n4];
            if (!Character.isDefined(c)) break;
            if (c2 == c) {
                if (++n4 != cArray.length) continue;
                n3 = i - n + 1;
                break;
            }
            n4 = 0;
        }
        return n3;
    }

    public StringBuilder getUTF8String(int n, StringBuilder stringBuilder, char ... cArray) {
        int n2 = this.size();
        int n3 = n + n2;
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            if (i >= n2) {
                return stringBuilder;
            }
            if (n4 == cArray.length) break;
            char c = this.getUTF8Char(i);
            stringBuilder.append(c);
            if (cArray[n4] == c) {
                ++n4;
                continue;
            }
            n4 = 0;
        }
        return stringBuilder;
    }

    public String getUTF8String(int n, char ... cArray) {
        StringBuilder stringBuilder = this.getUTF8String(n, new StringBuilder(), cArray);
        return stringBuilder.toString();
    }

    public StringBuilder getUTF8String(int n, StringBuilder stringBuilder, int n2) {
        int n3 = n + (this.size() < n2 ? this.size() : n2);
        for (int i = n; i < n3; ++i) {
            char c = this.getUTF8Char(i);
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    public String getUTF8String(int n, int n2) {
        return this.getUTF8String(n, new StringBuilder(), n2).toString();
    }

    public char getUTF8Char(int n) {
        return (char)this.getUByte(n);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public ByteOrder order() {
        return this.order ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public void order(ByteOrder byteOrder) {
        this.order = byteOrder == ByteOrder.BIG_ENDIAN;
    }

    public int peer(ByteBuffer byteBuffer) throws PeeringException {
        this.setReadonly(byteBuffer.isReadOnly());
        return super.peer(byteBuffer);
    }

    public int peer(JBuffer jBuffer) {
        this.setReadonly(jBuffer.isReadonly());
        return super.peer(jBuffer);
    }

    public int peer(JBuffer jBuffer, int n, int n2) throws IndexOutOfBoundsException {
        this.setReadonly(jBuffer.isReadonly());
        return super.peer(jBuffer, n, n2);
    }

    public void setByte(int n, byte by) {
        JBuffer.setByte0(this.physical, this.check(n, 1, this.physical), by);
    }

    private static native void setByte0(long var0, int var2, byte var3);

    public void setByteArray(int n, byte[] byArray) {
        JBuffer.setByteArray0(this.physical, this.check(n, byArray.length, this.physical), byArray, byArray.length);
    }

    private static native void setByteArray0(long var0, int var2, byte[] var3, int var4);

    public void setDouble(int n, double d) {
        JBuffer.setDouble0(this.physical, this.order, this.check(n, 8, this.physical), d);
    }

    private static native void setDouble0(long var0, boolean var2, int var3, double var4);

    public void setFloat(int n, float f) {
        JBuffer.setFloat0(this.physical, this.order, this.check(n, 4, this.physical), f);
    }

    private static native void setFloat0(long var0, boolean var2, int var3, float var4);

    public void setInt(int n, int n2) {
        JBuffer.setInt0(this.physical, this.order, this.check(n, 4, this.physical), n2);
    }

    private static native void setInt0(long var0, boolean var2, int var3, int var4);

    public void setLong(int n, long l) {
        JBuffer.setLong0(this.physical, this.order, this.check(n, 8, this.physical), l);
    }

    private static native void setLong0(long var0, boolean var2, int var3, long var4);

    public void setShort(int n, short s2) {
        JBuffer.setShort0(this.physical, this.order, this.check(n, 2, this.physical), s2);
    }

    public static native void setShort0(long var0, boolean var2, int var3, short var4);

    public void setUByte(int n, int n2) {
        JBuffer.setUByte0(this.physical, this.check(n, 1, this.physical), n2);
    }

    private static native void setUByte0(long var0, int var2, int var3);

    public void setUInt(int n, long l) {
        JBuffer.setUInt0(this.physical, this.order, this.check(n, 4, this.physical), l);
    }

    private static native void setUInt0(long var0, boolean var2, int var3, long var4);

    public void setUShort(int n, int n2) {
        JBuffer.setUShort0(this.physical, this.order, this.check(n, 2, this.physical), n2);
    }

    private static native void setUShort0(long var0, boolean var2, int var3, int var4);

    public int transferFrom(byte[] byArray) {
        return super.transferFrom(byArray);
    }

    public int transferFrom(ByteBuffer byteBuffer, int n) {
        return super.transferFrom(byteBuffer, n);
    }

    public int transferFrom(JBuffer jBuffer) {
        return jBuffer.transferTo(this);
    }

    public int transferTo(ByteBuffer byteBuffer, int n, int n2) {
        return super.transferTo(byteBuffer, n, n2);
    }

    public int transferTo(JBuffer jBuffer) {
        return super.transferTo(jBuffer);
    }

    public int transferTo(JBuffer jBuffer, int n, int n2, int n3) {
        return super.transferTo(jBuffer, n, n2, n3);
    }

    private final void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public native void setByteBuffer(int var1, ByteBuffer var2);

    public int peer(JMemory jMemory) {
        return super.peer(jMemory);
    }

    static {
        JNILibrary.register(JBuffer.class);
    }
}

