/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.newstuff;

import java.util.ArrayList;
import org.jnetpcap.newstuff.JHeaderContainer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.structure.AnnotatedHeader;

public class JHeaderBitmap<B extends JHeader>
implements JHeaderContainer<B> {
    public static final int MAX_HEADERS = 64;
    protected long optionsBitmap = -1L;
    protected int[] optionsOffsets = new int[64];
    protected int[] optionsLength = new int[64];
    protected final JHeader[] X_HEADERS = new JHeader[64];
    private final JHeader parent;
    private int count;

    public JHeaderBitmap(JHeader jHeader) {
        this.parent = jHeader;
        this.reorderAndSave(JHeaderBitmap.createHeaderInstances(jHeader.getAnnotatedHeader().getHeaders()));
    }

    private static JHeader[] createHeaderInstances(AnnotatedHeader ... annotatedHeaderArray) {
        JHeader[] jHeaderArray = new JHeader[annotatedHeaderArray.length];
        for (int i = 0; i < jHeaderArray.length; ++i) {
            jHeaderArray[i] = JHeaderBitmap.createHeaderInstance(annotatedHeaderArray[i]);
        }
        return jHeaderArray;
    }

    private static JHeader createHeaderInstance(AnnotatedHeader annotatedHeader) {
        try {
            return annotatedHeader.getHeaderClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
    }

    public void setSubHeaders(JHeader[] jHeaderArray) {
        this.reorderAndSave(jHeaderArray);
    }

    @Override
    public <T extends JSubHeader<B>> T getHeader(T t) {
        int n = this.optionsOffsets[t.getId()];
        int n2 = this.optionsLength[t.getId()];
        t.peer(this.parent, n, n2);
        t.setOffset(n);
        t.setLength(n2);
        t.setParent(this.parent);
        t.setPacket(this.parent.getPacket());
        return t;
    }

    @Override
    public JHeader getHeader(JHeader jHeader) {
        JSubHeader jSubHeader = (JSubHeader)jHeader;
        int n = jSubHeader.getId();
        int n2 = this.optionsOffsets[n];
        int n3 = this.optionsLength[n];
        jSubHeader.peer(this.parent, n2, n3);
        jSubHeader.setOffset(n2);
        jSubHeader.setLength(n3);
        jSubHeader.setParent(this.parent);
        return jHeader;
    }

    public JHeader[] getHeaders() {
        ArrayList<JHeader> arrayList = new ArrayList<JHeader>();
        for (int i = 0; i < 64; ++i) {
            if (!this.hasSubHeader(i) || this.X_HEADERS[i] == null) continue;
            JHeader jHeader = this.X_HEADERS[i];
            arrayList.add(this.X_HEADERS[i]);
        }
        return arrayList.toArray(new JHeader[arrayList.size()]);
    }

    public boolean hasSubHeader(int n) {
        return (this.optionsBitmap & (long)(1 << n)) > 0L;
    }

    public <T extends JSubHeader<B>> boolean hasSubHeader(T t) {
        if (this.hasSubHeader(t.getId())) {
            this.getHeader(t);
            return true;
        }
        return false;
    }

    private void reorderAndSave(JHeader[] jHeaderArray) {
        JHeader[] jHeaderArray2 = jHeaderArray;
        int n = jHeaderArray2.length;
        for (int i = 0; i < n; ++i) {
            JHeader jHeader;
            this.X_HEADERS[jHeader.getId()] = jHeader = jHeaderArray2[i];
        }
    }

    public boolean hasHeaders() {
        return this.optionsBitmap != 0L;
    }

    private void setHeader(int n, int n2, int n3) {
        this.optionsBitmap |= 1L << n;
        this.optionsLength[n] = n3;
        this.optionsOffsets[n] = n2;
    }

    @Override
    public void addHeader(int n, int n2, int n3) {
        if (this.hasSubHeader(n)) {
            throw new UnsupportedOperationException("header already set; bitmap header container supports single instances only");
        }
        this.setHeader(n, n2, n3);
        ++this.count;
    }

    @Override
    public void clear() {
        this.optionsBitmap = 0L;
        this.count = 0;
    }

    @Override
    public <T extends JSubHeader<B>> T getHeader(T t, int n) {
        if (n > 1) {
            throw new UnsupportedOperationException("header already set; bitmap header container supports single instances only");
        }
        return this.getHeader(t);
    }

    @Override
    public JHeader getHeaderByIndex(JHeader jHeader, int n) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public int getHeaderCount() {
        return this.count;
    }

    @Override
    public boolean hasHeader(int n, int n2) {
        if (n2 > 1) {
            return false;
        }
        return this.hasHeader(n);
    }

    @Override
    public B getHeader(B b, int n) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean hasHeader(int n) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean hasHeader(B b) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

