/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.newstuff;

import java.nio.ByteOrder;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeaderMap;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScan;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.annotate.Scanner;

@Header(name="IEEE 802.11 Radiotap", nicname="radiotap", dlt={PcapDLT.IEEE802_11_RADIO})
public class IEEE802dot11_RADIOTAP
extends JHeaderMap<IEEE802dot11_RADIOTAP> {
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    public static final int PRESESENT_MASK_TSFT = 1;
    public static final int PRESENT_MASK_FLAGS = 2;
    public static final int PRESENT_MASK_RATE = 4;
    public static final int PRESENT_MASK_CHANNEL = 8;
    public static final int PRESENT_MASK_FHSS = 16;
    public static final int PRESENT_MASK_DBM_ANTENNA_SIGNAL = 32;
    public static final int PRESENT_MASK_DBM_ANTENNA_NOISE = 64;
    public static final int PRESENT_MASK_LOCK_QUALITY = 128;
    public static final int PRESENT_MASK_TX_ATTENUATION = 256;
    public static final int PRESENT_MASK_DB_TX_ATTENUATION = 512;
    public static final int PRESENT_MASK_DBM_TX_POWER = 1024;
    public static final int PRESENT_MASK_ANTENNA = 2048;
    public static final int PRESENT_MASK_DB_ANTENNA_SIGNAL = 4096;
    public static final int PRESENT_MASK_DB_ANTENNA_NOISE = 8192;
    public static final int PRESENT_MASK_EXT = Integer.MIN_VALUE;
    public static final int IEEE80211_RADIOTAP_F_CFP = 1;
    public static final int IEEE80211_RADIOTAP_F_SHORTPRE = 2;
    public static final int IEEE80211_RADIOTAP_F_WEP = 4;
    public static final int IEEE80211_RADIOTAP_F_FRAG = 8;
    public static final int IEEE80211_RADIOTAP_F_FCS = 16;
    public static final int IEEE80211_RADIOTAP_F_DATAPAD = 32;
    public static final int IEEE80211_RADIOTAP_CHAN_TURBO = 16;
    public static final int IEEE80211_RADIOTAP_CHAN_CCK = 32;
    public static final int IEEE80211_RADIOTAP_CHAN_OFDM = 64;
    public static final int IEEE80211_RADIOTAP_CHAN_2GHZ = 128;
    public static final int IEEE80211_RADIOTAP_CHAN_5GHZ = 256;
    public static final int IEEE80211_RADIOTAP_CHAN_PASSIVE = 512;
    public static final int IEEE80211_RADIOTAP_CHAN_DYN = 1024;
    public static final int IEEE80211_RADIOTAP_CHAN_GFSK = 2048;

    public IEEE802dot11_RADIOTAP() {
        this.order(BYTE_ORDER);
    }

    @Field(offset=0, length=8, format="%d")
    public int version() {
        return super.getUByte(0);
    }

    @Field(offset=8, length=8, format="%d")
    public int pad() {
        return super.getUByte(1);
    }

    @Field(offset=16, length=16, format="%d")
    public int len() {
        return super.getUShort(2);
    }

    @HeaderLength
    public static int getHeaderLength(JBuffer jBuffer, int n) {
        return jBuffer.getUShort(n + 2);
    }

    @Field(offset=32, length=32, format="%x")
    public int present() {
        return super.getInt(4);
    }

    @Field(parent="present", offset=0, length=1, display="TSFT")
    public int present_TSFT() {
        return (this.present() & 1) >> 0;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_TSFTDescription() {
        return this.present_TSFT() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=1, length=1, display="Flags")
    public int present_Flags() {
        return (this.present() & 2) >> 1;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_FlagsDescription() {
        return this.present_Flags() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=2, length=1, display="Rate")
    public int present_Rate() {
        return (this.present() & 4) >> 2;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_RateDescription() {
        return this.present_Rate() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=3, length=1, display="Channel")
    public int present_Channel() {
        return (this.present() & 8) >> 3;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_ChannelDescription() {
        return this.present_Channel() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=4, length=1, display="FHSS")
    public int present_FHSS() {
        return (this.present() & 0x10) >> 4;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_FHSSDescription() {
        return this.present_FHSS() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=5, length=1, display="Antenna Signal")
    public int present_AntennaSignal() {
        return (this.present() & 0x20) >> 5;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_AntennaSignalDescription() {
        return this.present_AntennaSignal() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=6, length=1, display="Antenna Noise")
    public int present_AntennaNoise() {
        return (this.present() & 0x40) >> 6;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_AntennaNoiseDescription() {
        return this.present_AntennaNoise() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=7, length=1, display="Lock Quality")
    public int present_LockQuality() {
        return (this.present() & 0x80) >> 7;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_LockQualityDescription() {
        return this.present_LockQuality() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=8, length=1, display="TX Attenuation")
    public int present_TXAttenuation() {
        return (this.present() & 0x100) >> 8;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_TXAttenuationDescription() {
        return this.present_TXAttenuation() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=9, length=1, display="dB TX Attenuation")
    public int present_DBTXAttenuation() {
        return (this.present() & 0x200) >> 9;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_DBTXAttenuationDescription() {
        return this.present_DBTXAttenuation() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=10, length=1, display="dBm TX Power")
    public int present_DBMTXPower() {
        return (this.present() & 0x400) >> 10;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_DBMTXPowerDescription() {
        return this.present_DBMTXPower() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=11, length=1, display="Antenna")
    public int present_Antenna() {
        return (this.present() & 0x800) >> 11;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_AntennaDescription() {
        return this.present_Antenna() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=12, length=1, display="dB Antenna Signal")
    public int present_DBAntennaSignal() {
        return (this.present() & 0x1000) >> 12;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_DBAntennaSignalDescription() {
        return this.present_DBAntennaSignal() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=13, length=1, display="dB Antenna Noise")
    public int present_DBAntennaNoise() {
        return (this.present() & 0x2000) >> 13;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_DBAntennaNoiseDescription() {
        return this.present_DBAntennaNoise() > 0 ? "set" : "not set";
    }

    @Field(parent="present", offset=31, length=1, display="Ext")
    public int present_Ext() {
        return (this.present() & Integer.MIN_VALUE) >> 31;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String present_ExtDescription() {
        return this.present_Ext() > 0 ? "set" : "not set";
    }

    @Scanner
    public static void scanner(JScan jScan) {
        JPacket jPacket = jScan.scan_packet();
        int n = jScan.scan_offset();
        int n2 = JRegistry.lookupId(IEEE802dot11_RADIOTAP.class);
        jScan.scan_length(IEEE802dot11_RADIOTAP.getHeaderLength(jPacket, n));
    }

    @Override
    protected void decodeHeader() {
        this.optionsBitmap = 0L;
        int n = 8;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.present();
        int n6 = 0;
        for (IEEE80211_RADIOTAP_FIELDS iEEE80211_RADIOTAP_FIELDS : IEEE80211_RADIOTAP_FIELDS.values()) {
            n3 = iEEE80211_RADIOTAP_FIELDS.ordinal() + 1;
            n2 = n & (iEEE80211_RADIOTAP_FIELDS.size >> 4) - 1;
            n4 = (n5 & iEEE80211_RADIOTAP_FIELDS.mask) >> n3 - 1;
            this.optionsBitmap |= (long)(n4 << n3);
            if (n4 > 0) {
                if (n2 > 0) {
                    n += (iEEE80211_RADIOTAP_FIELDS.size >> 4) - n2;
                }
                n6 = iEEE80211_RADIOTAP_FIELDS.size & 0xF;
                this.optionsOffsets[n3] = n;
                this.optionsLength[n3] = n6;
                n += n6;
            }
            System.out.printf("id=%d name=%s is_present=%d present_bitmap=0x%X optionsBitmap=0x%X pad=%d offset of next field=%d length=%d  \n", n3, iEEE80211_RADIOTAP_FIELDS.name(), n4, n5, this.optionsBitmap, n2, n, this.optionsLength[n3]);
        }
    }

    public static enum IEEE80211_RADIOTAP_FIELDS {
        TSFT(1, 136),
        FLAGS(2, 17),
        RATE(4, 17),
        CHANNEL(8, 36),
        FHSS(16, 34),
        DBM_ANTENNA_SIGNAL(32, 17),
        DBM_ANTENNA_NOISE(64, 17),
        LOCK_QUALITY(128, 34),
        TX_ATTENUATION(256, 34),
        DB_TX_ATTENUATION(512, 34),
        DBM_TX_POWER(1024, 17),
        ANTENNA(2048, 17),
        DB_ANTENNA_SIGNAL(4096, 17),
        DB_ANTENNA_NOISE(8192, 17);

        private final int mask;
        private final int size;

        private IEEE80211_RADIOTAP_FIELDS(int n2, int n3) {
            this.mask = n2;
            this.size = n3;
        }

        public final int getMask() {
            return this.mask;
        }

        public final int getSize() {
            return this.size;
        }
    }

    public static enum IEEE80211_RADIOTAP_DATAFIELD_ID {
        NO_FIELD,
        TSFT,
        FLAGS,
        RATE,
        CHANNEL;

    }

    @Header(id=14)
    public static class DataField_DB_ANTENNA_NOISE
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%d", offset=0, length=8)
        public int DB_ANTENNA_NOISE() {
            return super.getUByte(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String DB_ANTENNA_NOISEDescription() {
            return this.DB_ANTENNA_NOISE() + " dB";
        }
    }

    @Header(id=13)
    public static class DataField_DB_ANTENNA_SIGNAL
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%d", offset=0, length=8)
        public int DB_ANTENNA_SIGNAL() {
            return super.getUByte(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String DB_ANTENNA_SIGNALDescription() {
            return this.DB_ANTENNA_SIGNAL() + " dB";
        }
    }

    @Header(id=12)
    public static class DataField_ANTENNA
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%d", offset=0, length=8)
        public int ANTENNA() {
            return super.getUByte(0);
        }
    }

    @Header(id=11)
    public static class DataField_DBM_TX_POWER
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%d", offset=0, length=8)
        public int DBM_TX_POWER() {
            return super.getByte(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String DBM_TX_POWERDescription() {
            return this.DBM_TX_POWER() + " dBm";
        }
    }

    @Header(id=10)
    public static class DataField_DB_TX_ATTENUATION
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 16;
        }

        @Field(format="%d", offset=0, length=16)
        public int DB_TX_ATTENUATION() {
            return super.getUShort(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String DB_TX_ATTENUATIONDescription() {
            return this.DB_TX_ATTENUATION() + " dB";
        }
    }

    @Header(id=9)
    public static class DataField_TX_ATTENUATION
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 16;
        }

        @Field(format="%d", offset=0, length=16)
        public int TX_ATTENUATION() {
            return super.getUShort(0);
        }
    }

    @Header(id=8)
    public static class DataField_LOCK_QUALITY
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 16;
        }

        @Field(format="%d", offset=0, length=16)
        public int LOCK_QUALITY() {
            return super.getUShort(0);
        }
    }

    @Header(id=7)
    public static class DataField_DBM_ANTENNA_NOISE
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%d", offset=0, length=8)
        public int DBM_ANTENNA_NOISE() {
            return super.getByte(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String DBM_ANTENNA_NOISEDescription() {
            return this.DBM_ANTENNA_NOISE() + " dBm";
        }
    }

    @Header(id=6)
    public static class DataField_DBM_ANTENNA_SIGNAL
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%d", offset=0, length=8)
        public int DBM_ANTENNA_SIGNAL() {
            return super.getByte(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String DBM_ANTENNA_SIGNALDescription() {
            return this.DBM_ANTENNA_SIGNAL() + " dBm";
        }
    }

    @Header(id=5)
    public static class DataField_FHSS
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 16;
        }

        @Field(format="%x", offset=0, length=8)
        public int firstByte() {
            return super.getUByte(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String firstByteDescription() {
            return "hop set";
        }

        @Field(format="%x", offset=8, length=8)
        public int secondByte() {
            return super.getUByte(1);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String secondByteDescription() {
            return "hop pattern";
        }
    }

    @Header(id=4)
    public static class DataField_Channel
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 32;
        }

        @Field(offset=0, format="%d", length=16)
        public int Channel() {
            return super.getUShort(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String ChannelDescription() {
            return this.Channel() + " MHz";
        }

        @Field(format="%x", offset=16, length=16)
        public int ChannelFlags() {
            return super.getUShort(2);
        }

        @Field(parent="ChannelFlags", offset=4, length=1, display="Turbo channel")
        public int ChannelFlags_TURBO() {
            return (this.ChannelFlags() & 0x10) >> 4;
        }

        @Field(parent="ChannelFlags", offset=5, length=1, display="CCK channel")
        public int ChannelFlags_CCK() {
            return (this.ChannelFlags() & 0x20) >> 5;
        }

        @Field(parent="ChannelFlags", offset=6, length=1, display="OFDM channel")
        public int ChannelFlags_OFDM() {
            return (this.ChannelFlags() & 0x40) >> 6;
        }

        @Field(parent="ChannelFlags", offset=7, length=1, display="2GHz channel")
        public int ChannelFlags_2GHz() {
            return (this.ChannelFlags() & 0x80) >> 7;
        }

        @Field(parent="ChannelFlags", offset=8, length=1, display="5GHz channel")
        public int ChannelFlags_5GHz() {
            return (this.ChannelFlags() & 0x100) >> 8;
        }

        @Field(parent="ChannelFlags", offset=9, length=1, display="Only passive scan allowed")
        public int ChannelFlags_PASSIVE() {
            return (this.ChannelFlags() & 0x200) >> 9;
        }

        @Field(parent="ChannelFlags", offset=10, length=1, display="Dynamic CCK-OFDM channel")
        public int ChannelFlags_DYN() {
            return (this.ChannelFlags() & 0x400) >> 10;
        }

        @Field(parent="ChannelFlags", offset=11, length=1, display="GFSK channel (FHSS PHY) ")
        public int ChannelFlags_GFSK() {
            return (this.ChannelFlags() & 0x800) >> 11;
        }
    }

    @Header(id=3)
    public static class DataField_Rate
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%d", offset=0, length=8)
        public int Rate() {
            return super.getUByte(0);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String RateDescription() {
            return this.Rate() * 500 + " Kbps";
        }
    }

    @Header(id=2)
    public static class DataField_Flags
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 8;
        }

        @Field(format="%x", offset=0, length=8)
        public int Flags() {
            return super.getUByte(0);
        }

        @Field(parent="Flags", offset=0, length=1, display="sent/recieved during CFP")
        public int Flags_CFP() {
            return (this.Flags() & 1) >> 0;
        }

        @Field(parent="Flags", offset=1, length=1, display="sent/received with short preamble")
        public int Flags_SHORTPRE() {
            return (this.Flags() & 2) >> 1;
        }

        @Field(parent="Flags", offset=2, length=1, display="sent/received with WEP encryption")
        public int Flags_WEP() {
            return (this.Flags() & 4) >> 2;
        }

        @Field(parent="Flags", offset=3, length=1, display="sent/received with fragmentation")
        public int Flags_FRAG() {
            return (this.Flags() & 8) >> 3;
        }

        @Field(parent="Flags", offset=4, length=1, display="frame includes FCS")
        public int Flags_FCS() {
            return (this.Flags() & 0x10) >> 4;
        }

        @Field(parent="Flags", offset=5, length=1, display="frame has padding between 802.11 header and payload (to 32-bit boundary)")
        public int Flags_DATAPAD() {
            return (this.Flags() & 0x20) >> 5;
        }
    }

    @Header(id=1)
    public static class DataField_TSFT
    extends DataField {
        @HeaderLength
        public static int getHeaderLength(JBuffer jBuffer, int n) {
            return 64;
        }

        @Field(format="%d", offset=0, length=64)
        public long TSFT() {
            return super.getLong(0);
        }
    }

    public static abstract class DataField
    extends JSubHeader<IEEE802dot11_RADIOTAP> {
        protected DataField() {
            this.order(ByteOrder.LITTLE_ENDIAN);
        }
    }
}

