/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelSicctCommandFacet;
import de.gematik.rbellogger.data.facet.RbelSicctEnvelopeFacet;
import de.gematik.rbellogger.data.facet.RbelSicctHeaderFacet;
import de.gematik.rbellogger.data.sicct.SicctMessageType;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelSicctEnvelopeConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelSicctEnvelopeConverter.class);

    @Override
    public void consumeElement(RbelElement element, RbelConverter context) {
        if (element.getParentNode() != null || element.hasFacet(RbelHttpMessageFacet.class) || element.getRawContent().length < 11) {
            return;
        }
        try {
            RbelSicctEnvelopeFacet envelopeFacet = this.buildEnvelopeFacet(element);
            element.addFacet(envelopeFacet);
            context.convertElement(envelopeFacet.getCommand());
            envelopeFacet.getMessageType().seekValue(SicctMessageType.class).ifPresent(msgType -> {
                if (msgType == SicctMessageType.C_COMMAND) {
                    element.findMessage().addFacet(new RbelRequestFacet(this.requestInfoString(envelopeFacet)));
                } else {
                    element.findMessage().addFacet(new RbelResponseFacet(Hex.toHexString(ArrayUtils.subarray(element.getRawContent(), element.getRawContent().length - 2, element.getRawContent().length))));
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private String requestInfoString(RbelSicctEnvelopeFacet envelopeFacet) {
        return envelopeFacet.getCommand().getFacet(RbelSicctCommandFacet.class).map(RbelSicctCommandFacet::getHeader).flatMap(el -> el.getFacet(RbelSicctHeaderFacet.class)).map(header -> header.getCommand().toString()).orElse("");
    }

    private RbelSicctEnvelopeFacet buildEnvelopeFacet(RbelElement element) {
        RbelElement commandElement = new RbelElement(ArrayUtils.subarray(element.getRawContent(), 10, element.getRawContent().length), element);
        commandElement.addFacet(new RbelBinaryFacet());
        return RbelSicctEnvelopeFacet.builder().messageType(RbelElement.wrap(new byte[]{element.getRawContent()[0]}, element, (Object)SicctMessageType.of(element.getRawContent()[0]))).srcOrDesAddress(new RbelElement(ArrayUtils.subarray(element.getRawContent(), 1, 3), element)).sequenceNumber(new RbelElement(ArrayUtils.subarray(element.getRawContent(), 3, 5), element)).abRfu(new RbelElement(ArrayUtils.subarray(element.getRawContent(), 5, 6), element)).length(new RbelElement(ArrayUtils.subarray(element.getRawContent(), 6, 10), element)).command(commandElement).build();
    }
}

