/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.bugs;

import java.io.File;
import java.io.FilenameFilter;
import junit.framework.Assert;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapUtils;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.format.FormatUtils;

public class Bug2847124_jbytebuffer_handler_memory_leak
extends TestUtils {
    private static final File DIR = new File("tests");
    private static final int COUNT = 10;
    private StringBuilder errbuf;
    int b = 0;
    int bytes = 0;
    int h = 0;
    int headers = 0;
    int total = 0;
    long start = 0L;
    long end = 0L;
    int count = 0;
    long ts = 0L;
    long te = 0L;

    @Override
    protected void setUp() throws Exception {
        this.errbuf = new StringBuilder();
    }

    @Override
    protected void tearDown() throws Exception {
        this.errbuf = null;
    }

    public void testInjectTestJPacketHandler() throws SigarException {
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        JBuffer jBuffer = new JBuffer(FormatUtils.toByteArray("0007e914 78a20010 7b812445 080045c000280005 0000ff11 70e7c0a8 62dec0a865e906a5 06a50014 e04ac802 000c000200000002 00060000 00000000"));
        PcapHeader pcapHeader = new PcapHeader(jBuffer.size(), jBuffer.size());
        PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
        System.out.printf("injected packet size=%d bytes\n", jBuffer.size());
        for (int i = 0; i < 10; ++i) {
            PcapUtils.injectLoop(10000, 1, new PcapPacketHandler<String>(){

                @Override
                public void nextPacket(PcapPacket pcapPacket, String string) {
                    Assert.assertNotNull((Object)pcapPacket);
                    ++Bug2847124_jbytebuffer_handler_memory_leak.this.count;
                    Bug2847124_jbytebuffer_handler_memory_leak.this.b += pcapPacket.size();
                    Bug2847124_jbytebuffer_handler_memory_leak.this.h += pcapPacket.getState().getHeaderCount();
                }
            }, "", pcapPacket);
            if (i == 0) {
                l2 = procMem.getSize();
            }
            if (i % 1 == 0 && i != 0) {
                this.te = System.currentTimeMillis();
                this.total += this.count;
                this.bytes += this.b;
                this.headers += this.h;
                double d = ((double)this.te - (double)this.ts) / 1000.0;
                procMem.gather(sigar, l);
                System.out.printf("tot=%.1f packets=%d pps=%.0f bytes=%.0fKb/s hdr=%.0f/s hdr=%.0fus rm=%dKb pm=%.1fb vm=%dKb\n", (double)this.total / 1024.0 / 1024.0, this.count, (double)this.count / d, (double)this.b / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d), procMem.getResident() / 1024L, ((double)procMem.getResident() - (double)l2) / (double)this.count, procMem.getSize() / 1024L);
                System.out.flush();
                this.ts = this.te;
                this.count = 0;
                this.b = 0;
                this.h = 0;
            }
            if (i % 1 != 0 || i == 0) continue;
            System.out.println("GC()");
            System.gc();
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        System.out.printf("totals: packets=%d average=%f pps bytes=%fKb/s headers=%f/s header_scan=%fus\n", this.count, (double)this.total / d, (double)this.bytes / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d));
        System.out.flush();
    }

    public void testStressTestJPacketHandler() throws SigarException {
        String[] stringArray = DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.equals("test-sip-rtp-g711.pcap");
            }
        });
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        for (int i = 0; i < 10; ++i) {
            for (String string : stringArray) {
                Pcap pcap = Pcap.openOffline(DIR.toString() + "/" + string, this.errbuf);
                Bug2847124_jbytebuffer_handler_memory_leak.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
                pcap.loop(-1, new JPacketHandler<Pcap>(){

                    @Override
                    public void nextPacket(JPacket jPacket, Pcap pcap) {
                        Assert.assertNotNull((Object)jPacket);
                        ++Bug2847124_jbytebuffer_handler_memory_leak.this.count;
                        Bug2847124_jbytebuffer_handler_memory_leak.this.b += jPacket.size();
                    }
                }, pcap);
                pcap.close();
            }
            if (i == 0) {
                l2 = procMem.getSize();
            }
            if (i % 1 == 0 && i != 0) {
                this.te = System.currentTimeMillis();
                this.total += this.count;
                this.bytes += this.b;
                this.headers += this.h;
                double d = ((double)this.te - (double)this.ts) / 1000.0;
                procMem.gather(sigar, l);
                System.out.printf("tot=%.1f packets=%d pps=%.0f bytes=%.0fKb/s hdr=%.0f/s hdr=%.0fus rm=%dKb pm=%.1fb vm=%dKb\n", (double)this.total / 1024.0 / 1024.0, this.count, (double)this.count / d, (double)this.b / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d), procMem.getResident() / 1024L, ((double)procMem.getResident() - (double)l2) / (double)this.count, procMem.getSize() / 1024L);
                System.out.flush();
                this.ts = this.te;
                this.count = 0;
                this.b = 0;
                this.h = 0;
            }
            if (i % 1 != 0 || i == 0) continue;
            System.out.println("GC()");
            System.gc();
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        System.out.printf("totals: packets=%d average=%f pps bytes=%fKb/s headers=%f/s header_scan=%fus\n", this.count, (double)this.total / d, (double)this.bytes / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d));
        System.out.flush();
    }

    public void testStressTestPcapPacketHandler() {
        String[] stringArray = DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pcap");
            }
        });
        for (int i = 0; i < 10; ++i) {
            for (String string : stringArray) {
                Pcap pcap = Pcap.openOffline(DIR.toString() + "/" + string, this.errbuf);
                Bug2847124_jbytebuffer_handler_memory_leak.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
                pcap.loop(-1, new PcapPacketHandler<Pcap>(){

                    @Override
                    public void nextPacket(PcapPacket pcapPacket, Pcap pcap) {
                        Assert.assertNotNull((Object)pcapPacket);
                    }
                }, pcap);
                pcap.close();
            }
            System.out.printf(".", new Object[0]);
            System.out.flush();
        }
        System.out.println();
    }

    public void testStressTestJBufferHandler() throws SigarException {
        String[] stringArray = DIR.list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".pcap");
            }
        });
        this.start = this.ts = System.currentTimeMillis();
        Sigar sigar = new Sigar();
        long l = sigar.getPid();
        ProcMem procMem = new ProcMem();
        long l2 = 0L;
        for (int i = 0; i < 10; ++i) {
            for (String string : stringArray) {
                Pcap pcap = Pcap.openOffline(DIR.toString() + "/" + string, this.errbuf);
                Bug2847124_jbytebuffer_handler_memory_leak.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
                pcap.loop(-1, new JBufferHandler<Pcap>(){

                    @Override
                    public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Pcap pcap) {
                        ++Bug2847124_jbytebuffer_handler_memory_leak.this.count;
                        Bug2847124_jbytebuffer_handler_memory_leak.this.b += jBuffer.size();
                    }
                }, pcap);
                pcap.close();
            }
            if (i == 0) {
                l2 = procMem.getSize();
            }
            if (i % 1 != 0 || i == 0) continue;
            this.te = System.currentTimeMillis();
            this.total += this.count;
            this.bytes += this.b;
            this.headers += this.h;
            double d = ((double)this.te - (double)this.ts) / 1000.0;
            procMem.gather(sigar, l);
            System.out.printf("tot=%.1fMp packets=%d pps=%.0f bytes=%.0fKb/s hdr=%.0f/s hdr=%.0fus rm=%dKb pm=%.1fb vm=%dKb\n", (double)this.total / 1024.0 / 1024.0, this.count, (double)this.count / d, (double)this.b / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d), procMem.getResident() / 1024L, ((double)procMem.getResident() - (double)l2) / (double)this.count, procMem.getSize() / 1024L);
            System.out.flush();
            this.ts = this.te;
            this.count = 0;
            this.b = 0;
            this.h = 0;
        }
        this.end = System.currentTimeMillis();
        double d = ((double)this.end - (double)this.start) / 1000.0;
        System.out.printf("totals: packets=%d average=%f pps bytes=%fKb/s headers=%f/s header_scan=%fus\n", this.count, (double)this.total / d, (double)this.bytes / d / 1024.0, (double)this.h / d, 1000000.0 / ((double)this.h / d));
        System.out.flush();
    }
}

