/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import de.gematik.rbellogger.modifier.RbelHttpHeaderWriter;
import de.gematik.rbellogger.modifier.RbelHttpResponseWriter;
import de.gematik.rbellogger.modifier.RbelJsonWriter;
import de.gematik.rbellogger.modifier.RbelJweWriter;
import de.gematik.rbellogger.modifier.RbelJwtWriter;
import de.gematik.rbellogger.modifier.RbelModificationDescription;
import de.gematik.rbellogger.modifier.RbelUriParameterWriter;
import de.gematik.rbellogger.modifier.RbelUriWriter;
import de.gematik.rbellogger.modifier.RbelVauEpaWriter;
import de.gematik.rbellogger.modifier.RbelVauErpWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class RbelModifier {
    private final RbelKeyManager rbelKeyManager;
    private final RbelConverter rbelConverter;
    private final List<RbelElementWriter> elementWriterList;
    private final Map<String, RbelModificationDescription> modificationsMap = new HashMap<String, RbelModificationDescription>();

    public RbelModifier(RbelKeyManager rbelKeyManager, RbelConverter rbelConverter) {
        this.rbelKeyManager = rbelKeyManager;
        this.rbelConverter = rbelConverter;
        this.elementWriterList = new ArrayList<RbelVauEpaWriter>(List.of(new RbelHttpHeaderWriter(), new RbelHttpResponseWriter(), new RbelJsonWriter(), new RbelUriWriter(), new RbelUriParameterWriter(), new RbelJwtWriter(this.rbelKeyManager), new RbelJweWriter(this.rbelKeyManager), new RbelVauErpWriter(), new RbelVauEpaWriter()));
    }

    public RbelElement applyModifications(RbelElement message) {
        RbelElement modifiedMessage = message;
        for (RbelModificationDescription modification : this.modificationsMap.values()) {
            Optional<RbelElement> targetOptional;
            if (!this.shouldBeApplied(modification, message) || (targetOptional = modifiedMessage.findElement(modification.getTargetElement())).isEmpty()) continue;
            byte[] input = this.applyModification(modification, targetOptional.get());
            modifiedMessage = this.rbelConverter.convertElement(input, null);
        }
        return modifiedMessage;
    }

    private boolean shouldBeApplied(RbelModificationDescription modification, RbelElement message) {
        if (StringUtils.isEmpty((CharSequence)modification.getCondition())) {
            return true;
        }
        RbelJexlExecutor executor = new RbelJexlExecutor();
        return executor.matchesAsJexlExpression(message, modification.getCondition(), Optional.empty());
    }

    private byte[] applyModification(RbelModificationDescription modification, RbelElement targetElement) {
        RbelElement oldTargetModifiedChild = targetElement;
        byte[] newContent = this.applyRegexAndReturnNewContent(targetElement, modification);
        for (RbelElement oldTargetElement = targetElement.getParentNode(); oldTargetElement != null; oldTargetElement = oldTargetElement.getParentNode()) {
            Optional<Object> found = Optional.empty();
            for (RbelElementWriter writer : this.elementWriterList) {
                if (!writer.canWrite(oldTargetElement)) continue;
                found = Optional.of(writer.write(oldTargetElement, oldTargetModifiedChild, newContent));
                break;
            }
            if (found.isEmpty()) {
                throw new RbelModificationException("Could not rewrite element with facets " + oldTargetElement.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.toList()) + "!");
            }
            newContent = (byte[])found.get();
            oldTargetModifiedChild = oldTargetElement;
        }
        return newContent;
    }

    private byte[] applyRegexAndReturnNewContent(RbelElement targetElement, RbelModificationDescription modification) {
        if (StringUtils.isEmpty((CharSequence)modification.getRegexFilter())) {
            if (modification.getReplaceWith() == null) {
                return "".getBytes(targetElement.getElementCharset());
            }
            return modification.getReplaceWith().getBytes(targetElement.getElementCharset());
        }
        return targetElement.getRawStringContent().replaceAll(modification.getRegexFilter(), modification.getReplaceWith()).getBytes(targetElement.getElementCharset());
    }

    public void deleteAllModifications() {
        this.modificationsMap.clear();
    }

    public void addModification(RbelModificationDescription modificationDescription) {
        if (StringUtils.isEmpty((CharSequence)modificationDescription.getName())) {
            String uuid = UUID.randomUUID().toString();
            modificationDescription.setName(uuid);
            this.modificationsMap.put(uuid, modificationDescription);
        } else {
            this.modificationsMap.put(modificationDescription.getName(), modificationDescription);
        }
    }

    public List<RbelModificationDescription> getModifications() {
        return this.modificationsMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toUnmodifiableList());
    }

    public void deleteModification(String modificationsId) {
        this.modificationsMap.remove(modificationsId);
    }

    @Generated
    public static RbelModifierBuilder builder() {
        return new RbelModifierBuilder();
    }

    @Generated
    public static class RbelModifierBuilder {
        @Generated
        private RbelKeyManager rbelKeyManager;
        @Generated
        private RbelConverter rbelConverter;

        @Generated
        RbelModifierBuilder() {
        }

        @Generated
        public RbelModifierBuilder rbelKeyManager(RbelKeyManager rbelKeyManager) {
            this.rbelKeyManager = rbelKeyManager;
            return this;
        }

        @Generated
        public RbelModifierBuilder rbelConverter(RbelConverter rbelConverter) {
            this.rbelConverter = rbelConverter;
            return this;
        }

        @Generated
        public RbelModifier build() {
            return new RbelModifier(this.rbelKeyManager, this.rbelConverter);
        }

        @Generated
        public String toString() {
            return "RbelModifier.RbelModifierBuilder(rbelKeyManager=" + this.rbelKeyManager + ", rbelConverter=" + this.rbelConverter + ")";
        }
    }

    public class RbelModificationException
    extends RuntimeException {
        public RbelModificationException(String s) {
            super(s);
        }
    }
}

