/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.elements;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class RbelJwtSignature
implements RbelFacet {
    private final RbelElement isValid;
    private final RbelElement verifiedUsing;

    @Override
    public List<Map.Entry<String, RbelElement>> getChildElements() {
        return List.of(Pair.of((Object)"isValid", (Object)this.isValid), Pair.of((Object)"verifiedUsing", (Object)this.verifiedUsing));
    }

    public boolean isValid() {
        return this.isValid.seekValue(Boolean.class).orElseThrow();
    }

    private String wasVerifiedUsing() {
        return Optional.ofNullable(this.verifiedUsing).flatMap(verifiedUsing -> verifiedUsing.seekValue(String.class)).orElse("");
    }

    @Generated
    public static RbelJwtSignatureBuilder builder() {
        return new RbelJwtSignatureBuilder();
    }

    @Generated
    public RbelElement getIsValid() {
        return this.isValid;
    }

    @Generated
    public RbelElement getVerifiedUsing() {
        return this.verifiedUsing;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelJwtSignature)) {
            return false;
        }
        RbelJwtSignature other = (RbelJwtSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$isValid = this.getIsValid();
        RbelElement other$isValid = other.getIsValid();
        if (this$isValid == null ? other$isValid != null : !this$isValid.equals(other$isValid)) {
            return false;
        }
        RbelElement this$verifiedUsing = this.getVerifiedUsing();
        RbelElement other$verifiedUsing = other.getVerifiedUsing();
        return !(this$verifiedUsing == null ? other$verifiedUsing != null : !this$verifiedUsing.equals(other$verifiedUsing));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelJwtSignature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $isValid = this.getIsValid();
        result = result * 59 + ($isValid == null ? 43 : $isValid.hashCode());
        RbelElement $verifiedUsing = this.getVerifiedUsing();
        result = result * 59 + ($verifiedUsing == null ? 43 : $verifiedUsing.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelJwtSignature(isValid=" + this.getIsValid() + ", verifiedUsing=" + this.getVerifiedUsing() + ")";
    }

    @ConstructorProperties(value={"isValid", "verifiedUsing"})
    @Generated
    public RbelJwtSignature(RbelElement isValid, RbelElement verifiedUsing) {
        this.isValid = isValid;
        this.verifiedUsing = verifiedUsing;
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelJwtSignature.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                return RbelHtmlRenderingToolkit.childBoxNotifTitle(element.getFacetOrFail(RbelJwtSignature.class).isValid() ? "is-success" : "is-primary").with((DomContent)RbelHtmlRenderingToolkit.t2("Signature")).with(RbelHtmlRenderingToolkit.addNotes(element, new String[0])).with((DomContent)TagCreator.p().withText("Was verified using Key ").with((DomContent)TagCreator.b((String)element.getFacetOrFail(RbelJwtSignature.class).wasVerifiedUsing())));
            }
        });
    }

    @Generated
    public static class RbelJwtSignatureBuilder {
        @Generated
        private RbelElement isValid;
        @Generated
        private RbelElement verifiedUsing;

        @Generated
        RbelJwtSignatureBuilder() {
        }

        @Generated
        public RbelJwtSignatureBuilder isValid(RbelElement isValid) {
            this.isValid = isValid;
            return this;
        }

        @Generated
        public RbelJwtSignatureBuilder verifiedUsing(RbelElement verifiedUsing) {
            this.verifiedUsing = verifiedUsing;
            return this;
        }

        @Generated
        public RbelJwtSignature build() {
            return new RbelJwtSignature(this.isValid, this.verifiedUsing);
        }

        @Generated
        public String toString() {
            return "RbelJwtSignature.RbelJwtSignatureBuilder(isValid=" + this.isValid + ", verifiedUsing=" + this.verifiedUsing + ")";
        }
    }
}

