/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.winpcap;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import junit.framework.TestCase;
import org.jnetpcap.PcapHandler;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapPktHdr;
import org.jnetpcap.winpcap.WinPcap;
import org.jnetpcap.winpcap.WinPcapRmtAuth;
import org.jnetpcap.winpcap.WinPcapSamp;
import org.jnetpcap.winpcap.WinPcapSendQueue;
import org.jnetpcap.winpcap.WinPcapStat;

public class TestWinPcapExtensions
extends TestCase {
    private static final String device = "\\Device\\NPF_{BC81C4FC-242F-4F1C-9DAD-EA9523CC992D}";
    private static final String rdevice = "\\Device\\NPF_{04BD71F0-BAD6-4C51-96A4-B05562FAD4F9}";
    private static final String rhost = "192.168.1.100";
    private static final String fname = "tests/test-l2tp.pcap";
    private static final int snaplen = 65536;
    private static final int flags = 1;
    private static final int promisc = 1;
    private static final int oneSecond = 1000;
    private StringBuilder errbuf;
    private final PcapHandler<?> doNothingHandler = new PcapHandler<Object>(){

        @Override
        public void nextPacket(Object object, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
        }
    };
    private PcapHandler<String> printTimestampHandler;
    private static File tmpFile;

    protected void setUp() throws Exception {
        this.errbuf = new StringBuilder();
        this.printTimestampHandler = new PcapHandler<String>(){
            private int i = 0;

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                Date date = new Date(l * 1000L);
                string = string == null ? "captured on" : string;
                System.out.printf("Packet #%d %s %s (cap=%d, len=%d)\n", this.i++, string, date, n2, n3);
            }
        };
    }

    protected void tearDown() throws Exception {
        if (tmpFile.exists()) {
            TestWinPcapExtensions.assertTrue((boolean)tmpFile.delete());
        }
    }

    public void testIsWinPcapExtSupported() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            TestWinPcapExtensions.assertTrue((boolean)WinPcap.isSupported());
        } else {
            TestWinPcapExtensions.assertFalse((boolean)WinPcap.isSupported());
        }
    }

    public void SKIPtestOpenLiveAndDispatch() {
        WinPcap winPcap = WinPcap.openLive(device, 10000, 1, 60000, this.errbuf);
        TestWinPcapExtensions.assertNotNull((Object)winPcap);
        PcapHandler<String> pcapHandler = new PcapHandler<String>(){

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                System.out.printf("%s, ts=%s caplen=%d len=%d capacity=%d\n", string.toString(), new Date(l * 1000L).toString(), n2, n3, byteBuffer.capacity());
            }
        };
        winPcap.dispatch(10, pcapHandler, "Hello");
        winPcap.close();
    }

    public void SKIPtestWinPcapStats() {
        WinPcap winPcap = WinPcap.openLive(device, 65536, 1, 1000, this.errbuf);
        winPcap.loop(50, this.doNothingHandler, null);
        WinPcapStat winPcapStat = winPcap.statsEx();
        System.out.printf("stats=%s\n", winPcapStat.toString());
        winPcap.close();
    }

    public void testSendQueueDepracated() {
        WinPcapSendQueue winPcapSendQueue = WinPcap.sendQueueAlloc(512);
        WinPcap winPcap = WinPcap.openLive(device, 65536, 1, 1000, this.errbuf);
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        PcapPktHdr pcapPktHdr = new PcapPktHdr(128, 128);
        winPcapSendQueue.queue(pcapPktHdr, byArray);
        winPcapSendQueue.queue(pcapPktHdr, byArray);
        Arrays.fill(byArray, (byte)17);
        winPcapSendQueue.queue(pcapPktHdr, byArray);
        int n = winPcap.sendQueueTransmit(winPcapSendQueue, 0);
        if (n != winPcapSendQueue.getLen()) {
            TestWinPcapExtensions.assertEquals((String)"transmit() call failed [", (int)winPcapSendQueue.getLen(), (int)n);
        }
        winPcap.close();
        WinPcap.sendQueueDestroy(winPcapSendQueue);
    }

    public void testSendQueue() {
        WinPcapSendQueue winPcapSendQueue = WinPcap.sendQueueAlloc(512);
        WinPcap winPcap = WinPcap.openLive(device, 65536, 1, 1000, this.errbuf);
        byte[] byArray = new byte[128];
        Arrays.fill(byArray, (byte)-1);
        PcapHeader pcapHeader = new PcapHeader(128, 128);
        winPcapSendQueue.queue(pcapHeader, byArray);
        winPcapSendQueue.queue(pcapHeader, byArray);
        Arrays.fill(byArray, (byte)17);
        winPcapSendQueue.queue(pcapHeader, byArray);
        int n = winPcap.sendQueueTransmit(winPcapSendQueue, 0);
        if (n != winPcapSendQueue.getLen()) {
            TestWinPcapExtensions.assertEquals((String)"transmit() call failed [", (int)winPcapSendQueue.getLen(), (int)n);
        }
        winPcap.close();
        WinPcap.sendQueueDestroy(winPcapSendQueue);
    }

    public void testSetSamplingLive() {
        WinPcap winPcap = WinPcap.openLive(device, 65536, 1, 1000, this.errbuf);
        TestWinPcapExtensions.assertNotNull((Object)winPcap);
        WinPcapSamp winPcapSamp = winPcap.setSampling();
        TestWinPcapExtensions.assertNotNull((Object)winPcapSamp);
        TestWinPcapExtensions.assertEquals((String)"method", (int)0, (int)winPcapSamp.getMethod());
        winPcapSamp.setMethod(2);
        winPcapSamp.setValue(10);
        TestWinPcapExtensions.assertEquals((String)"method", (int)2, (int)winPcapSamp.getMethod());
        winPcap.close();
    }

    public void testSetSamplingOffline() {
        WinPcap winPcap = WinPcap.openOffline(fname, this.errbuf);
        TestWinPcapExtensions.assertNotNull((Object)winPcap);
        WinPcapSamp winPcapSamp = winPcap.setSampling();
        TestWinPcapExtensions.assertNotNull((Object)winPcapSamp);
        TestWinPcapExtensions.assertEquals((String)"method", (int)0, (int)winPcapSamp.getMethod());
        winPcapSamp.setMethod(2);
        winPcapSamp.setValue(10);
        TestWinPcapExtensions.assertEquals((String)"method", (int)2, (int)winPcapSamp.getMethod());
        winPcap.close();
    }

    public void SKIPtestFindAllDevsEx() {
        String string = "rpcap://192.168.1.100/";
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        WinPcapRmtAuth winPcapRmtAuth = new WinPcapRmtAuth();
        int n = WinPcap.findAllDevsEx(string, winPcapRmtAuth, arrayList, this.errbuf);
        TestWinPcapExtensions.assertEquals((String)this.errbuf.toString(), (int)0, (int)n);
        TestWinPcapExtensions.assertFalse((String)"expected to find some devices", (boolean)arrayList.isEmpty());
    }

    public void SKIPtestRemoteOpen() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = WinPcap.createSrcStr(stringBuilder, 4, rhost, null, rdevice, this.errbuf);
        if (n != 0) {
            TestWinPcapExtensions.fail((String)this.errbuf.toString());
        } else {
            System.out.printf("source=%s\n", stringBuilder);
        }
        WinPcap winPcap = WinPcap.open(stringBuilder.toString(), 65536, 1, 1000, null, this.errbuf);
        TestWinPcapExtensions.assertNotNull((String)this.errbuf.toString(), (Object)winPcap);
        winPcap.loop(10, this.printTimestampHandler, null);
        winPcap.close();
    }

    public void testLiveDump() {
        System.out.printf("tmpFile=%s\n", tmpFile.getAbsoluteFile());
        WinPcap winPcap = WinPcap.openLive(device, 65536, 1, 1000, this.errbuf);
        TestWinPcapExtensions.assertNotNull((String)this.errbuf.toString(), (Object)winPcap);
        int n = winPcap.liveDump(tmpFile.getAbsolutePath(), 102400, 10);
        TestWinPcapExtensions.assertEquals((String)winPcap.getErr(), (int)0, (int)n);
        winPcap.liveDumpEnded(1);
        TestWinPcapExtensions.assertTrue((String)("Empty dump file " + tmpFile.getAbsolutePath()), (tmpFile.length() > 0L ? 1 : 0) != 0);
        winPcap.close();
    }

    static {
        try {
            tmpFile = File.createTempFile("temp-", "-TestPcapJNI");
        }
        catch (IOException iOException) {
            tmpFile = null;
        }
    }
}

