/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import junit.framework.TestCase;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.PeeringException;

public class TestJBuffer
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testGetByteArrayIntByteArray() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byte[] byArray = new byte[]{-86, 2, 10, 11, 12, 13, 3, -69};
        byteBuffer.put(byArray);
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byte[] byArray2 = new byte[8];
        TestJBuffer.assertEquals((int)8, (int)jBuffer.getByteArray(0, byArray2).length);
        TestJBuffer.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public final void testGetByteArrayIntInt() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byte[] byArray = new byte[]{-86, 2, 10, 11, 12, 13, 3, -69};
        byteBuffer.put(byArray);
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byte[] byArray2 = jBuffer.getByteArray(0, byArray.length);
        TestJBuffer.assertEquals((int)8, (int)byArray2.length);
        TestJBuffer.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public final void testIsReadonly() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byte[] byArray = new byte[]{-86, 2, 10, 11, 12, 13, 3, -69};
        byteBuffer.put(byArray);
        byteBuffer.flip();
        byteBuffer = byteBuffer.asReadOnlyBuffer();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        TestJBuffer.assertTrue((boolean)jBuffer.isReadonly());
        byte[] byArray2 = jBuffer.getByteArray(0, byArray.length);
        TestJBuffer.assertEquals((int)8, (int)byArray2.length);
        TestJBuffer.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public final void testOrder() {
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        TestJBuffer.assertEquals((Object)ByteOrder.nativeOrder(), (Object)jBuffer.order());
    }

    public final void testOrderByteOrder() {
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)jBuffer.order());
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((Object)ByteOrder.LITTLE_ENDIAN, (Object)jBuffer.order());
    }

    public final void testSetByte() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)4, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setByte(0, (byte)10);
        TestJBuffer.assertEquals((byte)byteBuffer.get(0), (byte)jBuffer.getByte(0));
    }

    public final void testSetByteArray() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.clear();
        byte[] byArray = new byte[]{-86, 2, 10, 11, 12, 13, 3, -69};
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        jBuffer.setByteArray(0, byArray);
        byte[] byArray2 = new byte[8];
        byteBuffer.get(byArray2);
        TestJBuffer.assertTrue((boolean)Arrays.equals(byArray, byArray2));
    }

    public final void testSetDouble() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setDouble(0, 1.0E33f);
        TestJBuffer.assertEquals((Object)byteBuffer.getDouble(0), (Object)jBuffer.getDouble(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((Object)byteBuffer.getDouble(0), (Object)jBuffer.getDouble(0));
    }

    public final void testSetFloat() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)4, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setFloat(0, 1.0E33f);
        TestJBuffer.assertEquals((Object)Float.valueOf(byteBuffer.getFloat(0)), (Object)Float.valueOf(jBuffer.getFloat(0)));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((Object)Float.valueOf(byteBuffer.getFloat(0)), (Object)Float.valueOf(jBuffer.getFloat(0)));
    }

    public final void testSetInt() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)4, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setInt(0, 10);
        TestJBuffer.assertEquals((int)byteBuffer.getInt(0), (int)jBuffer.getInt(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((int)byteBuffer.getInt(0), (int)jBuffer.getInt(0));
    }

    public final void testSetLong() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setLong(0, 10L);
        TestJBuffer.assertEquals((long)byteBuffer.getLong(0), (long)jBuffer.getLong(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((long)byteBuffer.getLong(0), (long)jBuffer.getLong(0));
    }

    public final void testSetShort() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setShort(0, (short)10);
        TestJBuffer.assertEquals((short)byteBuffer.getShort(0), (short)jBuffer.getShort(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((short)byteBuffer.getShort(0), (short)jBuffer.getShort(0));
    }

    public final void testSetUByte() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setUByte(0, 10);
        TestJBuffer.assertEquals((int)byteBuffer.get(0), (int)jBuffer.getUByte(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((int)byteBuffer.get(0), (int)jBuffer.getUByte(0));
    }

    public final void testSetUInt() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setUInt(0, 10L);
        TestJBuffer.assertEquals((long)byteBuffer.getInt(0), (long)jBuffer.getUInt(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((long)byteBuffer.getInt(0), (long)jBuffer.getUInt(0));
    }

    public final void testSetUShort() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.clear();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setUShort(0, 10);
        TestJBuffer.assertEquals((int)byteBuffer.getShort(0), (int)jBuffer.getUShort(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((int)byteBuffer.getShort(0), (int)jBuffer.getUShort(0));
    }

    public final void testTransferToJBuffer() {
        JBuffer jBuffer = new JBuffer(8);
        JBuffer jBuffer2 = new JBuffer(8);
        byte[] byArray = new byte[]{-86, 2, 10, 11, 12, 13, 3, -69};
        jBuffer.setByteArray(0, byArray);
        jBuffer.transferTo(jBuffer2);
        TestJBuffer.assertTrue((boolean)Arrays.equals(byArray, jBuffer2.getByteArray(0, 8)));
    }

    public final void testTransferToJBufferIntIntInt() {
        JBuffer jBuffer = new JBuffer(8);
        JBuffer jBuffer2 = new JBuffer(8);
        byte[] byArray = new byte[]{-86, 2, 10, 11, 12, 13, 3, -69};
        jBuffer.setByteArray(0, byArray);
        jBuffer.transferTo(jBuffer2, 2, 4, 4);
        TestJBuffer.assertTrue((boolean)Arrays.equals(new byte[]{10, 11, 12, 13}, jBuffer2.getByteArray(4, 4)));
    }

    public void testJBufferByte() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.put(new byte[]{1, 2, 3, 4});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)4, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((byte)byteBuffer.get(0), (byte)jBuffer.getByte(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((byte)byteBuffer.get(0), (byte)jBuffer.getByte(0));
    }

    public void testJBufferShort() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.put(new byte[]{1, 2, 3, 4});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)4, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((short)byteBuffer.getShort(0), (short)jBuffer.getShort(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((short)byteBuffer.getShort(0), (short)jBuffer.getShort(0));
    }

    public void testJBufferInt() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.put(new byte[]{1, 2, 3, 4});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)4, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((int)byteBuffer.getInt(0), (int)jBuffer.getInt(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((int)byteBuffer.getInt(0), (int)jBuffer.getInt(0));
    }

    public void testJBufferLong() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.put(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((long)byteBuffer.getLong(0), (long)jBuffer.getLong(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((long)byteBuffer.getLong(0), (long)jBuffer.getLong(0));
    }

    public void testJBufferUByte() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.put(new byte[]{-86, -69});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)2, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((int)170, (int)jBuffer.getUByte(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((int)170, (int)jBuffer.getUByte(0));
    }

    public void testJBufferUShort() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.put(new byte[]{-86, -69});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)2, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((int)48042, (int)jBuffer.getUShort(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((int)43707, (int)jBuffer.getUShort(0));
    }

    public void testJBufferUInt() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4);
        byteBuffer.put(new byte[]{-86, 2, 3, -69});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)4, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((long)3137536682L, (long)jBuffer.getUInt(0));
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((long)2852258747L, (long)jBuffer.getUInt(0));
    }

    public void testJBufferGetterBounds() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.put(new byte[]{-86, 2, 3, -69, 1, 2, 3, 4});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        try {
            jBuffer.getByte(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getShort(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getInt(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getLong(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getUByte(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getUShort(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getUInt(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getByte(8);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getShort(7);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getInt(5);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getLong(1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getUInt(-1);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getUByte(8);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getUShort(7);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        try {
            jBuffer.getUInt(5);
            TestJBuffer.fail((String)"Underflow exception expected");
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
    }

    public void testJBufferFloat() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.put(new byte[]{-86, 2, 10, 11, 12, 13, 3, -69});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        jBuffer.peer(byteBuffer);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        TestJBuffer.assertEquals((Object)Float.valueOf(byteBuffer.getFloat(0)), (Object)Float.valueOf(jBuffer.getFloat(0)));
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((Object)Float.valueOf(byteBuffer.getFloat(0)), (Object)Float.valueOf(jBuffer.getFloat(0)));
    }

    public void testJBufferDouble() throws PeeringException {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(8);
        byteBuffer.put(new byte[]{-86, 2, 10, 11, 12, 13, 3, -69});
        byteBuffer.flip();
        JBuffer jBuffer = new JBuffer(JMemory.Type.POINTER);
        TestJBuffer.assertTrue((jBuffer.peer(byteBuffer) != 0 ? 1 : 0) != 0);
        TestJBuffer.assertEquals((int)8, (int)jBuffer.size());
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        Double.longBitsToDouble(0L);
        TestJBuffer.assertEquals((Object)100.0, (Object)(jBuffer.getDouble(0) / byteBuffer.getDouble(0) * 100.0));
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        TestJBuffer.assertEquals((Object)byteBuffer.getDouble(0), (Object)jBuffer.getDouble(0));
    }
}

