/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jnetpcap.HttpTrafficGenerator;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHandler;
import org.jnetpcap.PcapIf;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.tcpip.Tcp;

public class TestTransmitter
extends TestCase {
    private static final String linux = "any";
    private static final String device = "any";
    private static final int OK = 0;
    private static final int snaplen = 65536;
    private static final int promisc = 1;
    private static final int oneSecond = 1000;
    private static final HttpTrafficGenerator gen = new HttpTrafficGenerator();
    private static File tmpFile;
    private StringBuilder errbuf = new StringBuilder();
    private final PcapHandler<?> doNothingHandler = new PcapHandler<Object>(){

        @Override
        public void nextPacket(Object object, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
        }
    };

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 && "-h".equals(stringArray[0])) {
            System.out.println("Usage: java -jar jnetpcap.jar [-h]\n  -h  This help message\n   (No other command line options are supported.)\n----------------------------------------------------------------\n\nThe 'main' method invoked here, runs several dozen jUnit tests\nwhich test the functionality of this jNetPcap library.\nThe tests are actual excersizes using native libpcap\nlibrary linked with 'jnetpcap.dll' or 'libjnetpcap.so' on\nunix systems.\n\nIf you are having trouble linking the native library and get\n'UnsatisfiedLinkError', which means java is not finding the\nlibrary, here are a few pointers:\n\nJava's native library loader DOES NOT USE CLASSPATH variable\nto locate native libraries. Each operating system uses different\nalgorithm to locate files, as described below. You can always\nforce java to look for native library with Java VM command\nline option 'java -Djava.library.path=lib' where lib is\na directory where 'jnetpcap.dll' or 'libjnetpcap.so' resides\nrelative to the installation directory of jNetStream package.\nOr replace lib with the directory where you have installed the\nlibrary.\n\nOn Win32 systems:\n  Windows systems use /windows and /windows/system32 folder\n  to search for jnetpcap.dll. Also the 'PATH' variable, the same\n  one used to specify executable commands, is used as well.\n\nOn Unix systems:\n  All unix systems use the standard 'LD_LIBRARY_PATH' variable.\n\nOf course as mentioned earlier, to override this behaviour use\nthe '-Djava.library.path=' directory, to force java to look in\nthat particular directory. Do not set the path which includes the\nname of the library itself, just the directory to search in.\n\nFinal note, native librariers can not be loaded from jar files.\nYou have to extract it to a physical directory if you want java to\nload it. This was done purposely by Sun for security reasons.");
            return;
        }
        TestRunner.main((String[])new String[]{"org.jnetpcap.TestPcapJNI"});
    }

    protected void setUp() throws Exception {
        this.errbuf = new StringBuilder();
        if (tmpFile.exists()) {
            TestTransmitter.assertTrue((boolean)tmpFile.delete());
        }
    }

    public void tearDown() throws Exception {
    }

    public void testSendPacketUsingByteArray() {
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        int n = Pcap.findAllDevs(arrayList, this.errbuf);
        if (n == -1 || arrayList.isEmpty()) {
            System.err.printf("Can't read list of devices, error is %s", this.errbuf.toString());
            return;
        }
        PcapIf pcapIf = (PcapIf)arrayList.get(1);
        Pcap pcap = Pcap.openLive(pcapIf.getName(), 65536, 1, 10000, this.errbuf);
        TestTransmitter.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        byte[] byArray = new byte[14];
        Arrays.fill(byArray, (byte)-1);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (pcap.sendPacket(byteBuffer) != 0) {
            TestTransmitter.fail((String)pcap.getErr());
        }
        pcap.close();
    }

    public void testInjectPacket() {
        Pcap pcap = Pcap.openLive("eth0", 65536, 1, 10000, this.errbuf);
        TestTransmitter.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        byte[] byArray = new byte[14];
        Arrays.fill(byArray, (byte)-1);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (pcap.inject(byteBuffer) < 0) {
            TestTransmitter.fail((String)pcap.getErr());
        }
        pcap.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendPacketUsingJBuffer() throws UnknownHostException {
        JMemoryPacket jMemoryPacket = new JMemoryPacket(1, "0016b6c13cb10021 5db0456c08004500 00340e8e40008006 9c54c0a80165d822 b5b1c1cf005020ce 4303000000008002 2000d94300000204 05b4010303020101 0402");
        InetAddress inetAddress = InetAddress.getByName("201.1.1.1");
        InetAddress inetAddress2 = InetAddress.getByName("192.168.1.1");
        Ip4 ip4 = jMemoryPacket.getHeader(new Ip4());
        Tcp tcp = jMemoryPacket.getHeader(new Tcp());
        ip4.destination(inetAddress.getAddress());
        ip4.source(inetAddress2.getAddress());
        ip4.checksum(ip4.calculateChecksum());
        tcp.checksum(tcp.calculateChecksum());
        jMemoryPacket.scan(1);
        System.out.println(jMemoryPacket);
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = Pcap.findAllDevs(arrayList, stringBuilder);
        if (n == -1 || arrayList.isEmpty()) {
            System.err.printf("Can't read list of devices, error is %s", stringBuilder.toString());
            return;
        }
        PcapIf pcapIf = (PcapIf)arrayList.get(0);
        int n2 = 65536;
        int n3 = 0;
        int n4 = 10000;
        Pcap pcap = Pcap.openLive(pcapIf.getName(), n2, n3, n4, stringBuilder);
        System.out.println("Device ->" + pcapIf.getName());
        try {
            if (pcap.sendPacket(jMemoryPacket) != 0) {
                System.err.println(pcap.getErr());
            }
        }
        finally {
            pcap.close();
        }
    }

    static {
        try {
            tmpFile = File.createTempFile("temp-", "-TestPcapJNI");
        }
        catch (IOException iOException) {
            tmpFile = null;
            System.err.println("Unable to initialize a temporary file");
        }
    }
}

