/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.jnetpcap.ByteBufferHandler;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;
import org.jnetpcap.packet.format.FormatUtils;

public class TestPcapDispatchers
extends TestCase {
    private static final int COUNT = 3;
    private StringBuilder errbuf = new StringBuilder();
    private Pcap pcap;
    private static final String TEST_AFS = "tests/test-afs.pcap";
    private static final Counter COUNTER = new Counter();

    private Pcap open(String string) {
        return Pcap.openOffline(string, this.errbuf);
    }

    private void loop(String string, JPacketHandler<Counter> jPacketHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.loop(-1, jPacketHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    private void dispatch(String string, JPacketHandler<Counter> jPacketHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.dispatch(-1, jPacketHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    private void loop(String string, PcapPacketHandler<Counter> pcapPacketHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.loop(-1, pcapPacketHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    private void dispatch(String string, PcapPacketHandler<Counter> pcapPacketHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.dispatch(-1, pcapPacketHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    private void loop(String string, JBufferHandler<Counter> jBufferHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.loop(-1, jBufferHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    private void dispatch(String string, JBufferHandler<Counter> jBufferHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.dispatch(-1, jBufferHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    private void loop(String string, ByteBufferHandler<Counter> byteBufferHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.loop(-1, byteBufferHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    private void dispatch(String string, ByteBufferHandler<Counter> byteBufferHandler) {
        this.pcap = this.open(string);
        TestPcapDispatchers.assertEquals((int)0, (int)this.pcap.dispatch(-1, byteBufferHandler, COUNTER));
        this.pcap.close();
        this.pcap = null;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        if (this.pcap != null) {
            this.pcap.close();
            this.pcap = null;
        }
    }

    public final void testDispatchIntByteBufferHandlerOfTTLoop() {
        for (int i = 0; i < 3; ++i) {
            this.loop(TEST_AFS, new ByteBufferHandler<Counter>(){

                @Override
                public void nextPacket(PcapHeader pcapHeader, ByteBuffer byteBuffer, Counter counter) {
                    counter.inc();
                    ByteBuffer.allocateDirect(byteBuffer.capacity()).put(byteBuffer);
                }
            });
        }
    }

    public final void testDispatchIntByteBufferHandlerOfTTDispatch() {
        for (int i = 0; i < 3; ++i) {
            this.dispatch(TEST_AFS, new ByteBufferHandler<Counter>(){

                @Override
                public void nextPacket(PcapHeader pcapHeader, ByteBuffer byteBuffer, Counter counter) {
                    counter.inc();
                    ByteBuffer.allocateDirect(byteBuffer.capacity()).put(byteBuffer);
                }
            });
        }
    }

    public final void testDispatchIntIntJPacketHandlerOfTTLoop() {
        for (int i = 0; i < 3; ++i) {
            this.loop(TEST_AFS, new JPacketHandler<Counter>(){

                @Override
                public void nextPacket(JPacket jPacket, Counter counter) {
                    counter.inc();
                    new JMemoryPacket(jPacket.size()).transferStateAndDataFrom(jPacket);
                }
            });
        }
    }

    public final void testDispatchIntIntJPacketHandlerOfTTDispatch() {
        for (int i = 0; i < 3; ++i) {
            this.dispatch(TEST_AFS, new JPacketHandler<Counter>(){

                @Override
                public void nextPacket(JPacket jPacket, Counter counter) {
                    counter.inc();
                    new JMemoryPacket(jPacket.size()).transferStateAndDataFrom(jPacket);
                }
            });
        }
    }

    public final void testDispatchIntIntPcapPacketHandlerOfTTLoop() {
        for (int i = 0; i < 3; ++i) {
            this.loop(TEST_AFS, new PcapPacketHandler<Counter>(){

                @Override
                public void nextPacket(PcapPacket pcapPacket, Counter counter) {
                    counter.inc();
                    new PcapPacket(pcapPacket);
                }
            });
        }
    }

    public final void testDispatchIntIntPcapPacketHandlerOfTTDispatch() {
        for (int i = 0; i < 3; ++i) {
            this.dispatch(TEST_AFS, new PcapPacketHandler<Counter>(){

                @Override
                public void nextPacket(PcapPacket pcapPacket, Counter counter) {
                    counter.inc();
                    new PcapPacket(pcapPacket);
                }
            });
        }
    }

    public final void testDispatchIntJBufferHandlerOfTTLoop() {
        for (int i = 0; i < 3; ++i) {
            this.loop(TEST_AFS, new JBufferHandler<Counter>(){

                @Override
                public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Counter counter) {
                    counter.inc();
                    new JBuffer(jBuffer.size()).transferFrom(jBuffer);
                }
            });
        }
    }

    public final void testDispatchIntJBufferHandlerOfTTDispatch() {
        for (int i = 0; i < 3; ++i) {
            this.dispatch(TEST_AFS, new JBufferHandler<Counter>(){

                @Override
                public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, Counter counter) {
                    counter.inc();
                    new JBuffer(jBuffer.size()).transferFrom(jBuffer);
                }
            });
        }
    }

    public final void _testDispatchIntJPacketHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    public final void _testDispatchIntPcapPacketHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    public final void _testLoopIntByteBufferHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    public final void _testLoopIntIntJPacketHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    public final void _testLoopIntIntPcapPacketHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    public final void _testLoopIntJBufferHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    public final void _testLoopIntJPacketHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    public final void _testLoopIntPcapPacketHandlerOfTT() {
        TestPcapDispatchers.fail((String)"Not yet implemented");
    }

    private static class Counter {
        public long count = 0L;
        public long ts = System.currentTimeMillis();

        private Counter() {
        }

        public void inc() {
            if (++this.count % 100000L == 0L) {
                long l = System.currentTimeMillis() - this.ts;
                System.out.printf("100K #%d @ %s, mem+%d, mem-%d mem=%d, calls+%d calls-%d\n", this.count / 100000L, FormatUtils.formatTimeInMillis(l), (int)JMemory.totalAllocated(), JMemory.totalDeAllocated(), JMemory.totalActiveAllocated(), JMemory.totalAllocateCalls(), JMemory.totalDeAllocateCalls());
                this.ts = System.currentTimeMillis();
            }
        }
    }
}

