/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jnetpcap.ByteBufferHandler;
import org.jnetpcap.HttpTrafficGenerator;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapBpfProgram;
import org.jnetpcap.PcapClosedException;
import org.jnetpcap.PcapDLT;
import org.jnetpcap.PcapDumper;
import org.jnetpcap.PcapHandler;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapInteger;
import org.jnetpcap.PcapPktBuffer;
import org.jnetpcap.PcapPktHdr;
import org.jnetpcap.PcapStat;
import org.jnetpcap.nio.JNumber;

public class TestPcapBetaJNI
extends TestCase {
    private static final String win = "\\Device\\NPF_{BC81C4FC-242F-4F1C-9DAD-EA9523CC992D}";
    private static final String linux = "any";
    private static final boolean isWindows = "Windows XP".equals(System.getProperty("os.name"));
    private static final String device = isWindows ? "\\Device\\NPF_{BC81C4FC-242F-4F1C-9DAD-EA9523CC992D}" : "any";
    private static final String fname = "tests/test-l2tp.pcap";
    private static final int OK = 0;
    private static final int snaplen = 65536;
    private static final int promisc = 1;
    private static final int oneSecond = 1000;
    private static final HttpTrafficGenerator gen = new HttpTrafficGenerator();
    private static File tmpFile;
    private StringBuilder errbuf = new StringBuilder();
    private final PcapHandler<?> doNothingHandler = new PcapHandler<Object>(){

        @Override
        public void nextPacket(Object object, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
        }
    };

    public static void main(String[] stringArray) {
        if (stringArray.length == 1 && "-h".equals(stringArray[0])) {
            System.out.println("Usage: java -jar jnetpcap.jar [-h]\n  -h  This help message\n   (No other command line options are supported.)\n----------------------------------------------------------------\n\nThe 'main' method invoked here, runs several dozen jUnit tests\nwhich test the functionality of this jNetPcap library.\nThe tests are actual excersizes using native libpcap\nlibrary linked with 'jnetpcap.dll' or 'libjnetpcap.so' on\nunix systems.\n\nIf you are having trouble linking the native library and get\n'UnsatisfiedLinkError', which means java is not finding the\nlibrary, here are a few pointers:\n\nJava's native library loader DOES NOT USE CLASSPATH variable\nto locate native libraries. Each operating system uses different\nalgorithm to locate files, as described below. You can always\nforce java to look for native library with Java VM command\nline option 'java -Djava.library.path=lib' where lib is\na directory where 'jnetpcap.dll' or 'libjnetpcap.so' resides\nrelative to the installation directory of jNetStream package.\nOr replace lib with the directory where you have installed the\nlibrary.\n\nOn Win32 systems:\n  Windows systems use /windows and /windows/system32 folder\n  to search for jnetpcap.dll. Also the 'PATH' variable, the same\n  one used to specify executable commands, is used as well.\n\nOn Unix systems:\n  All unix systems use the standard 'LD_LIBRARY_PATH' variable.\n\nOf course as mentioned earlier, to override this behaviour use\nthe '-Djava.library.path=' directory, to force java to look in\nthat particular directory. Do not set the path which includes the\nname of the library itself, just the directory to search in.\n\nFinal note, native librariers can not be loaded from jar files.\nYou have to extract it to a physical directory if you want java to\nload it. This was done purposely by Sun for security reasons.");
            return;
        }
        TestRunner.main((String[])new String[]{"org.jnetpcap.TestPcapJNI"});
    }

    protected void setUp() throws Exception {
        this.errbuf = new StringBuilder();
        if (tmpFile.exists()) {
            TestPcapBetaJNI.assertTrue((boolean)tmpFile.delete());
        }
    }

    public void SKIPtestOpenLiveAndDispatch() {
        Pcap pcap = Pcap.openLive(device, 10000, 1, 60000, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapHandler<String> pcapHandler = new PcapHandler<String>(){

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
            }
        };
        pcap.dispatch(10, pcapHandler, "Hello");
        pcap.close();
    }

    protected void tearDown() throws Exception {
        this.errbuf = null;
        gen.stop();
        if (tmpFile != null && tmpFile.exists()) {
            tmpFile.delete();
        }
    }

    public void testCompileNoPcapNullPtrHandling() {
        try {
            Pcap.compileNoPcap(1, 1, null, null, 1, 1);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompileNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.compile(null, null, 1, 0);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    public void testDataLinkNameToValNullPtrHandling() {
        try {
            Pcap.datalinkNameToVal(null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPcapClosedExceptionHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        pcap.close();
        try {
            pcap.breakloop();
            TestPcapBetaJNI.fail((String)"Expected PcapClosedException");
        }
        catch (PcapClosedException pcapClosedException) {
            // empty catch block
        }
    }

    public void testDatalinkNameToValue() {
        TestPcapBetaJNI.assertEquals((int)1, (int)Pcap.datalinkNameToVal("EN10MB"));
    }

    public void testDatalinkValueToDescription() {
        TestPcapBetaJNI.assertEquals((String)"Ethernet", (String)Pcap.datalinkValToDescription(1));
    }

    public void testDatalinkValueToName() {
        TestPcapBetaJNI.assertEquals((String)"EN10MB", (String)Pcap.datalinkValToName(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDispatchNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.dispatch(1, (ByteBufferHandler)null, "");
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    public void testErrbuf() throws SocketException, InterruptedException {
        this.errbuf.append("def");
        Pcap pcap = Pcap.openLive("abc", 101, 1, 60, this.errbuf);
        TestPcapBetaJNI.assertNull((Object)pcap);
        TestPcapBetaJNI.assertFalse((String)"Our pre-initialized error message should have been cleared", (boolean)"def".equals(this.errbuf.toString()));
        TestPcapBetaJNI.assertTrue((String)"Error buffer should contain an error message", (this.errbuf.length() != 0 ? 1 : 0) != 0);
    }

    public void testFilterCompileAndSetFilter() {
        PcapBpfProgram pcapBpfProgram = new PcapBpfProgram();
        String string = "host 192.168.101";
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        int n = pcap.compile(pcapBpfProgram, string, 0, 0);
        TestPcapBetaJNI.assertEquals((String)pcap.getErr(), (int)0, (int)n);
        PcapHandler<String> pcapHandler = new PcapHandler<String>(){

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
            }
        };
        TestPcapBetaJNI.assertEquals((int)0, (int)pcap.setFilter(pcapBpfProgram));
        TestPcapBetaJNI.assertEquals((int)0, (int)pcap.loop(10, pcapHandler, string));
        Pcap.freecode(pcapBpfProgram);
        pcap.close();
    }

    public void testFilterCompileNoPcapAndAccessors() {
        PcapBpfProgram pcapBpfProgram = new PcapBpfProgram();
        String string = "host 192.168.1.1";
        int n = Pcap.compileNoPcap(1024, 1, pcapBpfProgram, string, 0, 0);
        TestPcapBetaJNI.assertEquals((int)0, (int)n);
        TestPcapBetaJNI.assertEquals((int)26, (int)pcapBpfProgram.getInstructionCount());
        TestPcapBetaJNI.assertEquals((long)120259084320L, (long)pcapBpfProgram.getInstruction(10));
        try {
            pcapBpfProgram.getInstruction(-10);
            TestPcapBetaJNI.fail((String)"Failed to generate exception on low index boundary");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            pcapBpfProgram.getInstruction(26);
            TestPcapBetaJNI.fail((String)"Failed to generate exception on upper index boundary");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Pcap.freecode(pcapBpfProgram);
    }

    public void testFindAllDevs() {
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        int n = Pcap.findAllDevs(arrayList, this.errbuf);
        TestPcapBetaJNI.assertEquals((String)this.errbuf.toString(), (int)0, (int)n);
        TestPcapBetaJNI.assertFalse((boolean)arrayList.isEmpty());
    }

    public void testFindAllDevsNullPtrHandling() {
        try {
            Pcap.findAllDevs(null, null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFreeAllDevsNullPtrHandling() {
        try {
            Pcap.freeAllDevs(null, (StringBuilder)null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testFreeCodeNullPtrHandling() {
        try {
            Pcap.freecode(null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetNonBlockNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.getNonBlock(null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    public void testLibVersion() {
        TestPcapBetaJNI.assertNotNull((Object)Pcap.libVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLoopNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.loop(1, (ByteBufferHandler)null, null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNextExNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.nextEx((PcapHeader)null, null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNextNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.next(null, null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    public void testOpenDeadAndClose() {
        Pcap pcap = Pcap.openDead(1, 10000);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        pcap.close();
    }

    public void testOpenLiveAndDatalinkAndClose() throws SocketException, InterruptedException {
        Pcap pcap = Pcap.openLive(device, 101, 1, 60, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        TestPcapBetaJNI.assertFalse((boolean)"0".equals(pcap.toString()));
        pcap.close();
        try {
            pcap.close();
            TestPcapBetaJNI.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testOpenLiveAndLoopWithBreakloop() {
        Pcap pcap = Pcap.openLive(device, 10000, 1, 60000, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapHandler<String> pcapHandler = new PcapHandler<String>(){

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
            }
        };
        pcap.breakloop();
        TestPcapBetaJNI.assertEquals((String)"Error code does not indicate breakloop interrupted the loop when it should have", (int)-2, (int)pcap.loop(10, pcapHandler, "Hello"));
        pcap.close();
    }

    public void testOpenOfflineAndClose() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapHandler<String> pcapHandler = new PcapHandler<String>(){

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
            }
        };
        TestPcapBetaJNI.assertEquals((String)"Expected to receive exactly 10 packets", (int)10, (int)pcap.dispatch(10, pcapHandler, "Hello"));
        pcap.close();
    }

    public void testOpenOfflineAndLoop() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapHandler<String> pcapHandler = new PcapHandler<String>(){

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
            }
        };
        TestPcapBetaJNI.assertEquals((int)0, (int)pcap.loop(10, pcapHandler, "Hello"));
        pcap.close();
    }

    public void testOpenOfflineAndNext() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapPktHdr pcapPktHdr = new PcapPktHdr();
        ByteBuffer byteBuffer = pcap.next(pcapPktHdr);
        TestPcapBetaJNI.assertEquals((int)114, (int)byteBuffer.capacity());
        TestPcapBetaJNI.assertEquals((int)114, (int)pcapPktHdr.getCaplen());
        TestPcapBetaJNI.assertEquals((int)114, (int)pcapPktHdr.getLen());
        pcap.close();
    }

    public void testOpenOfflineAndNextEx() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapPktHdr pcapPktHdr = new PcapPktHdr();
        PcapPktBuffer pcapPktBuffer = new PcapPktBuffer();
        int n = pcap.nextEx(pcapPktHdr, pcapPktBuffer);
        TestPcapBetaJNI.assertEquals((int)1, (int)n);
        TestPcapBetaJNI.assertNotNull((Object)pcapPktBuffer.getBuffer());
        TestPcapBetaJNI.assertEquals((int)114, (int)pcapPktBuffer.getBuffer().capacity());
        TestPcapBetaJNI.assertEquals((int)114, (int)pcapPktHdr.getCaplen());
        TestPcapBetaJNI.assertEquals((int)114, (int)pcapPktHdr.getLen());
        pcap.close();
    }

    public void testPcapDLTAndDoNameToValueComparison() {
        int n = 0;
        for (PcapDLT pcapDLT : PcapDLT.values()) {
            int n2 = pcapDLT.value;
            String string = Pcap.datalinkValToName(n2);
            if (string == null || !string.equals(pcapDLT.name())) continue;
            ++n;
        }
        TestPcapBetaJNI.assertTrue((String)"Something is wrong, most constants should match native pcap library", (n > 20 ? 1 : 0) != 0);
    }

    public void testPcapOpenLiveNullPtrHandling() {
        try {
            Pcap.openLive(null, 1, 1, 1, null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPcapOpenOfflineNullPtrHandling() {
        try {
            Pcap.openOffline(null, null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testSetAndGetNonblock() {
        Pcap pcap = Pcap.openLive(device, 10000, 1, 60000, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        TestPcapBetaJNI.assertEquals((int)0, (int)pcap.getNonBlock(this.errbuf));
        pcap.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetFilterNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.setFilter(null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNonBlockNullPtrHandling() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        try {
            pcap.setNonBlock(1, null);
            TestPcapBetaJNI.fail((String)"Expected a NULL pointer exception.");
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            pcap.close();
        }
    }

    public void testPcapHandlerParentOverrideBugUsingLoop() {
        Pcap pcap;
        AtomicInteger atomicInteger;
        PcapHandler<Object> pcapHandler;
        int n;
        Pcap pcap2 = Pcap.openOffline(fname, this.errbuf);
        if (pcap2 == null) {
            TestPcapBetaJNI.fail((String)("Unable to open test data file because " + this.errbuf.toString()));
        }
        if ((n = pcap2.loop(-1, pcapHandler = new PcapHandler<Object>(atomicInteger = new AtomicInteger(), pcap = pcap2){
            private int count = 0;
            final /* synthetic */ AtomicInteger val$pcapCount;
            final /* synthetic */ Pcap val$parent;
            {
                this.val$pcapCount = atomicInteger;
                this.val$parent = pcap;
            }

            @Override
            public void nextPacket(Object object, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                this.val$pcapCount.addAndGet(1);
                ++this.count;
                if (this.val$pcapCount.get() != this.count) {
                    this.val$parent.breakloop();
                }
            }
        }, null)) == -2) {
            TestPcapBetaJNI.fail((String)"Handler indicates that 2 tracking variables in 2 objects, did not match");
        } else if (n != 0) {
            TestPcapBetaJNI.fail((String)("Error occured: " + pcap2.getErr()));
        }
        pcap2.close();
    }

    public void testPcapHandlerParentOverrideBugUsingDispatch() {
        Pcap pcap;
        AtomicInteger atomicInteger;
        PcapHandler<Object> pcapHandler;
        int n;
        Pcap pcap2 = Pcap.openOffline(fname, this.errbuf);
        if (pcap2 == null) {
            TestPcapBetaJNI.fail((String)("Unable to open test data file because " + this.errbuf.toString()));
        }
        if ((n = pcap2.dispatch(-1, pcapHandler = new PcapHandler<Object>(atomicInteger = new AtomicInteger(), pcap = pcap2){
            private int count = 0;
            final /* synthetic */ AtomicInteger val$pcapCount;
            final /* synthetic */ Pcap val$parent;
            {
                this.val$pcapCount = atomicInteger;
                this.val$parent = pcap;
            }

            @Override
            public void nextPacket(Object object, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                this.val$pcapCount.addAndGet(1);
                ++this.count;
                if (this.val$pcapCount.get() != this.count) {
                    this.val$parent.breakloop();
                }
            }
        }, null)) == -2) {
            TestPcapBetaJNI.fail((String)"Handler indicates that 2 tracking variables in 2 objects, did not match");
        } else if (n != 0) {
            TestPcapBetaJNI.fail((String)("Error occured: " + pcap2.getErr()));
        }
        pcap2.close();
    }

    public void testPcapDumperUsingLoop() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapDumper pcapDumper = pcap.dumpOpen(tmpFile.getPath());
        TestPcapBetaJNI.assertNotNull((String)pcap.getErr(), (Object)pcapDumper);
        PcapHandler<PcapDumper> pcapHandler = new PcapHandler<PcapDumper>(){

            @Override
            public void nextPacket(PcapDumper pcapDumper, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                pcapDumper.dump(l, n, n2, n3, byteBuffer);
            }
        };
        int n = pcap.loop(-1, pcapHandler, pcapDumper);
        TestPcapBetaJNI.assertTrue((String)"Something happened in the loop", (n == 0 ? 1 : 0) != 0);
        pcapDumper.close();
        pcap.close();
        TestPcapBetaJNI.assertEquals((String)"dumped file and source file lengths don't match", (long)tmpFile.length(), (long)new File(fname).length());
    }

    public void testPcapDumperUsingDispatch() {
        Pcap pcap = Pcap.openOffline(fname, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapDumper pcapDumper = pcap.dumpOpen(tmpFile.getPath());
        TestPcapBetaJNI.assertNotNull((String)pcap.getErr(), (Object)pcapDumper);
        PcapHandler<PcapDumper> pcapHandler = new PcapHandler<PcapDumper>(){

            @Override
            public void nextPacket(PcapDumper pcapDumper, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                pcapDumper.dump(l, n, n2, n3, byteBuffer);
            }
        };
        int n = pcap.dispatch(-1, pcapHandler, pcapDumper);
        TestPcapBetaJNI.assertTrue((String)"Something happened in dispatch", (n == 0 ? 1 : 0) != 0);
        pcapDumper.close();
        pcap.close();
        TestPcapBetaJNI.assertEquals((String)"dumped file and source file lengths don't match", (long)tmpFile.length(), (long)new File(fname).length());
    }

    public void _testStats() {
        PcapStat pcapStat = new PcapStat();
        Pcap pcap = Pcap.openLive(device, 65536, 1, 1000, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        pcap.loop(5, this.doNothingHandler, null);
        pcap.stats(pcapStat);
        pcap.loop(5, this.doNothingHandler, null);
        pcap.stats(pcapStat);
        pcap.close();
    }

    public void SKIPtestDumper() {
        gen.start();
        System.out.printf("tmpFile=%s\n", tmpFile.getAbsoluteFile());
        Pcap pcap = Pcap.openLive(device, 65536, 1, 1000, this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)pcap);
        PcapDumper pcapDumper = pcap.dumpOpen(tmpFile.getAbsolutePath());
        TestPcapBetaJNI.assertNotNull((String)pcap.getErr(), (Object)pcapDumper);
        PcapHandler<PcapDumper> pcapHandler = new PcapHandler<PcapDumper>(){

            @Override
            public void nextPacket(PcapDumper pcapDumper, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                pcapDumper.dump(l, n, n2, n3, byteBuffer);
            }
        };
        pcap.loop(10, pcapHandler, pcapDumper);
        TestPcapBetaJNI.assertTrue((String)("Empty dump file " + tmpFile.getAbsolutePath()), (tmpFile.length() > 0L ? 1 : 0) != 0);
        pcap.close();
    }

    public void testLookupDevAndLookupNetDeprecatedAPI() {
        String string = Pcap.lookupDev(this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)string);
        PcapInteger pcapInteger = new PcapInteger();
        PcapInteger pcapInteger2 = new PcapInteger();
        int n = Pcap.lookupNet(string, pcapInteger, pcapInteger2, this.errbuf);
        TestPcapBetaJNI.assertEquals((String)this.errbuf.toString(), (int)0, (int)n);
        System.out.printf("device=%s netp=%X maskp=%X errbuf=%s\n", string, pcapInteger.getValue(), pcapInteger2.getValue(), this.errbuf.toString());
    }

    public void testLookupDevAndLookupNetNewAPI() {
        String string = Pcap.lookupDev(this.errbuf);
        TestPcapBetaJNI.assertNotNull((String)this.errbuf.toString(), (Object)string);
        JNumber jNumber = new JNumber(JNumber.Type.INT);
        JNumber jNumber2 = new JNumber(JNumber.Type.INT);
        int n = Pcap.lookupNet(string, jNumber, jNumber2, this.errbuf);
        TestPcapBetaJNI.assertEquals((String)this.errbuf.toString(), (int)0, (int)n);
        System.out.printf("device=%s netp=%X maskp=%X errbuf=%s\n", string, jNumber.intValue(), jNumber2.intValue(), this.errbuf.toString());
    }

    public void testIsInjectSupportedWin32() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            TestPcapBetaJNI.assertFalse((boolean)Pcap.isInjectSupported());
        } else {
            TestPcapBetaJNI.assertTrue((boolean)true);
        }
    }

    public void testIsSendpacketSupportedWin32() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            TestPcapBetaJNI.assertTrue((boolean)Pcap.isSendPacketSupported());
        } else {
            TestPcapBetaJNI.assertTrue((boolean)true);
        }
    }

    static {
        try {
            tmpFile = File.createTempFile("temp-", "-TestPcapJNI");
        }
        catch (IOException iOException) {
            tmpFile = null;
            System.err.println("Unable to initialize a temporary file");
        }
    }
}

