/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import junit.framework.TestCase;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapHandler;
import org.jnetpcap.PcapIf;

public class TestClassicExample
extends TestCase {
    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testInfiniteLoopForProfiling() {
        ArrayList<PcapIf> arrayList = new ArrayList<PcapIf>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = Pcap.findAllDevs(arrayList, stringBuilder);
        if (n == -1 || arrayList.isEmpty()) {
            System.err.printf("Can't read list of devices, error is %s", stringBuilder.toString());
            return;
        }
        System.out.println("Network devices found:");
        int n2 = 0;
        for (PcapIf pcapIf : arrayList) {
            System.out.printf("#%d: %s [%s]\n", n2++, pcapIf.getName(), pcapIf.getDescription());
        }
        PcapIf pcapIf = (PcapIf)arrayList.get(0);
        System.out.printf("\nChoosing '%s' on your behalf:\n", pcapIf.getDescription());
        int n3 = 65536;
        int n4 = 1;
        int n5 = 10000;
        Pcap pcap = Pcap.openLive(pcapIf.getName(), n3, n4, n5, stringBuilder);
        if (pcap == null) {
            System.err.printf("Error while opening device for capture: " + stringBuilder.toString(), new Object[0]);
            return;
        }
        PcapHandler<String> pcapHandler = new PcapHandler<String>(){

            @Override
            public void nextPacket(String string, long l, int n, int n2, int n3, ByteBuffer byteBuffer) {
                Date date = new Date(l * 1000L + (long)(n / 1000));
                System.out.printf("Received packet at %s caplen=%-4d len=%-4d %s\n", date.toString(), n2, n3, string);
            }
        };
        pcap.loop(10, pcapHandler, "jNetPcap rocks!");
        pcap.close();
    }
}

