/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import java.beans.ConstructorProperties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class GenericPrettyPrinter<T> {
    private final Predicate<T> isLeaf;
    private final Function<T, String> nodePrinter;
    private final Function<T, Stream<T>> leafRetriever;
    private String openingBrace = "[";
    private String closingBrace = "]";
    private String depthStepper = "\t";

    public String prettyPrint(T root) {
        return this.prettyPrint(root, 0);
    }

    private String prettyPrint(T node, int depth) {
        if (this.isLeaf.test(node)) {
            return this.depthStepper.repeat(depth) + this.openingBrace + "\n" + this.leafRetriever.apply(node).map(leaf -> this.prettyPrint(leaf, depth + 1)).collect(Collectors.joining(",\n")) + "\n" + this.depthStepper.repeat(depth) + this.closingBrace;
        }
        return this.depthStepper.repeat(depth) + this.nodePrinter.apply(node);
    }

    @ConstructorProperties(value={"isLeaf", "nodePrinter", "leafRetriever"})
    @Generated
    public GenericPrettyPrinter(Predicate<T> isLeaf, Function<T, String> nodePrinter, Function<T, Stream<T>> leafRetriever) {
        this.isLeaf = isLeaf;
        this.nodePrinter = nodePrinter;
        this.leafRetriever = leafRetriever;
    }
}

