/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.vpn;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;

@Header
public class L2TP
extends JHeader {
    public static final int FLAG_L = 16384;
    public static final int FLAG_O = 512;
    public static final int FLAG_P = 256;
    public static final int FLAG_S = 2048;
    public static final int FLAG_T = 32768;
    public static final int ID = 10;
    public static final int MASK_VERSION = 14;
    public static final int MASK_FLAGS = 65521;
    private int offId;
    private int offLength;
    private int offOffset;
    private int offSequence;

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        int n2 = jBuffer.getUShort(0);
        int n3 = 6;
        if ((n2 & 0x4000) != 0) {
            n3 += 2;
        }
        if ((n2 & 0x800) != 0) {
            n3 += 4;
        }
        if ((n2 & 0x200) != 0) {
            n3 += 4;
        }
        return n3;
    }

    public void decodeHeader() {
        int n = this.flags();
        int n2 = 2;
        if (this.isSet(n, 16384)) {
            this.offLength = 2;
            n2 += 2;
        } else {
            this.offLength = 0;
        }
        this.offId = n2;
        n2 += 4;
        if (this.isSet(n, 2048)) {
            this.offSequence = n2;
            n2 += 4;
        } else {
            this.offSequence = 0;
        }
        if (this.isSet(n, 512)) {
            this.offOffset = n2;
            n2 += 4;
        } else {
            this.offOffset = 0;
        }
    }

    @Field(offset=0, length=12, format="%x")
    public int flags() {
        return this.getUShort(0) & 0xFFF1;
    }

    @Dynamic(value=Field.Property.CHECK)
    public boolean hasLength() {
        return this.isSet(this.flags(), 16384);
    }

    @Dynamic(value=Field.Property.CHECK)
    public boolean hasN() {
        return this.isSet(this.flags(), 2048);
    }

    @Dynamic(value=Field.Property.CHECK)
    public boolean hasOffset() {
        return this.isSet(this.flags(), 512);
    }

    private boolean isSet(int n, int n2) {
        return (n & n2) != 0;
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int lengthOffset() {
        return this.offLength * 8;
    }

    @Field(length=16)
    public int length() {
        return this.getUShort(this.offLength);
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int nrOffset() {
        return (this.offSequence + 2) * 8;
    }

    @Field(length=16)
    public int nr() {
        return this.getUShort(this.offSequence + 2);
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int nsOffset() {
        return this.offSequence * 8;
    }

    @Field(length=16)
    public int ns() {
        return this.getUShort(this.offSequence);
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int offsetOffset() {
        return this.offOffset * 8;
    }

    @Field(length=16)
    public int offset() {
        return this.getUShort(this.offOffset);
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int padOffset() {
        return (this.offLength + 2) * 8;
    }

    @Field(length=16)
    public int pad() {
        return this.getUShort(this.offOffset + 2);
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int sessionIdOffset() {
        return this.offId * 2 * 8;
    }

    @Field(length=16)
    public int sessionId() {
        return this.getUShort(this.offId + 2);
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int tunnelIdOffset() {
        return this.offId * 8;
    }

    @Field(length=16)
    public int tunnelId() {
        return this.getUShort(this.offId);
    }

    @Field(offset=13, length=3)
    public int version() {
        return this.getUShort(0) & 0xE;
    }
}

