/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.bugs;

import java.nio.ByteOrder;
import junit.framework.TestCase;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JMemoryPacket;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.network.Ip4;
import org.jnetpcap.protocol.tcpip.Udp;
import org.jnetpcap.util.checksum.Checksum;

public class Bug2878768_jmemory_packet_int
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void test1() {
        JMemoryPacket jMemoryPacket = new JMemoryPacket(64);
        jMemoryPacket.order(ByteOrder.BIG_ENDIAN);
        jMemoryPacket.setUShort(12, 2048);
        jMemoryPacket.setUByte(14, 69);
        System.out.println(jMemoryPacket.toHexdump());
        jMemoryPacket.setUByte(23, 17);
        System.out.println(jMemoryPacket.toHexdump());
        jMemoryPacket.scan(1);
        Ethernet ethernet = jMemoryPacket.getHeader(new Ethernet());
        Ip4 ip4 = jMemoryPacket.getHeader(new Ip4());
        Udp udp = jMemoryPacket.getHeader(new Udp());
        ethernet.destination(new byte[]{-86, 12, 8, 11, 22, 33});
        ethernet.source(new byte[]{-86, 12, 8, 11, 22, 34});
        ip4.flags(0);
        ip4.tos(0);
        ip4.source(new byte[]{-64, -88, 18, -38});
        ip4.setByteArray(16, new byte[]{-64, -88, 18, -37});
        ip4.checksum(0);
        System.out.printf("crc=0x%X ip.len=%d\n", Checksum.inChecksum(ip4, 0, ip4.size()), ip4.size());
        ip4.checksum(Checksum.inChecksum(ip4, 0, ip4.size()));
        System.out.println(jMemoryPacket.getState().toDebugString());
        System.out.printf("crc=0x%X\n", Checksum.inChecksum(ip4, 0, ip4.size()));
        JBuffer jBuffer = new JBuffer(4);
        jBuffer.order(ByteOrder.LITTLE_ENDIAN);
        jBuffer.setUInt(0, 0x14010100L);
        System.out.printf("0x%X\n%s", 0x14010100, jBuffer.toHexdump());
        jBuffer.order(ByteOrder.BIG_ENDIAN);
        jBuffer.setUInt(0, 0x14010100L);
        System.out.printf("0x%X\n%s", 0x14010100, jBuffer.toHexdump());
    }
}

