/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class RbelHttpHeaderFacet
implements RbelFacet,
Map<String, RbelElement> {
    private final Map<String, List<RbelElement>> values;

    public RbelHttpHeaderFacet() {
        this.values = new LinkedHashMap<String, List<RbelElement>>();
    }

    public RbelHttpHeaderFacet(Map<String, List<RbelElement>> values) {
        this.values = values;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.values.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsKey(value);
    }

    @Override
    public RbelElement get(Object key) {
        List<RbelElement> list = this.values.get(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public RbelElement put(String key, RbelElement value) {
        if (!this.values.containsKey(key)) {
            this.values.put(key, new ArrayList());
        }
        this.values.get(key).add(value);
        return value;
    }

    @Override
    public RbelElement remove(Object key) {
        List<RbelElement> list = this.values.remove(key);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public void putAll(Map<? extends String, ? extends RbelElement> m3) {
        for (Map.Entry<? extends String, ? extends RbelElement> entry : m3.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    @Override
    public List<RbelElement> values() {
        return this.values.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, RbelElement>> entrySet() {
        HashSet<Map.Entry<String, RbelElement>> result = new HashSet<Map.Entry<String, RbelElement>>();
        result.addAll(this.getChildElements());
        return result;
    }

    @Override
    public List<Map.Entry<String, RbelElement>> getChildElements() {
        return this.values.entrySet().stream().flatMap(entry -> {
            if (((List)entry.getValue()).isEmpty()) {
                return Stream.of(new Pair[0]);
            }
            return ((List)entry.getValue()).stream().map(value -> Pair.of((String)entry.getKey(), value));
        }).collect(Collectors.toList());
    }

    public Stream<RbelElement> getCaseInsensitiveMatches(String key) {
        String lowerCaseKey = key.toLowerCase();
        return this.values.entrySet().stream().filter(entry -> entry.getKey() != null).filter(entry -> ((String)entry.getKey()).toLowerCase().equals(lowerCaseKey)).map(Map.Entry::getValue).flatMap(Collection::stream);
    }

    public boolean hasValueMatching(String headerKey, String prefix) {
        return this.values.entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(headerKey)).map(Map.Entry::getValue).flatMap(Collection::stream).map(RbelElement::getRawStringContent).anyMatch(str -> str.startsWith(prefix));
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelHttpHeaderFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                return ((ContainerTag)TagCreator.table().withClass("table")).with(TagCreator.thead(TagCreator.tr(TagCreator.th("name"), TagCreator.th("value"))), TagCreator.tbody().with(element.getFacetOrFail(RbelHttpHeaderFacet.class).getChildElements().stream().map(entry -> {
                    DomContent[] domContentArray = new DomContent[2];
                    domContentArray[0] = TagCreator.td(TagCreator.pre((String)entry.getKey()));
                    domContentArray[1] = TagCreator.td(new DomContent[]{TagCreator.pre().with((DomContent)renderingToolkit.convert((RbelElement)entry.getValue(), Optional.ofNullable((String)entry.getKey()))).withClass("value")}).with(RbelHtmlRenderingToolkit.addNotes((RbelElement)entry.getValue(), new String[0]));
                    return TagCreator.tr(domContentArray);
                }).collect(Collectors.toList())));
            }
        });
    }
}

