/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.converter;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.rbellogger.util.RbelException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.AbstractBranch;
import org.dom4j.tree.DefaultComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RbelXmlConverter
implements RbelConverterPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelXmlConverter.class);
    private static final String XML_TEXT_KEY = "text";

    @Override
    public void consumeElement(RbelElement rbel, RbelConverter context) {
        String content = rbel.getRawStringContent();
        if (content.contains("<") && content.contains(">")) {
            try {
                this.buildXmlElementForNode(this.parseXml(content.trim(), rbel), rbel, context);
                rbel.addFacet(new RbelRootFacet<RbelXmlFacet>(rbel.getFacetOrFail(RbelXmlFacet.class)));
            }
            catch (DocumentException e) {
                log.trace("Exception while trying to parse XML. Skipping", e);
            }
        }
    }

    private Branch parseXml(String text, RbelElement parentElement) throws DocumentException {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        InputSource source = new InputSource(new StringReader(text));
        source.setEncoding(parentElement.getElementCharset().name());
        return reader.read(source);
    }

    private void buildXmlElementForNode(Branch branch, RbelElement parentElement, RbelConverter converter) {
        ArrayList<Map.Entry<String, RbelElement>> childElements = new ArrayList<Map.Entry<String, RbelElement>>();
        parentElement.addFacet(RbelXmlFacet.builder().sourceElement(branch).childElements(childElements).build());
        for (Object child : branch.content()) {
            if (child instanceof Text) {
                childElements.add(Pair.of(XML_TEXT_KEY, converter.convertElement(((Text)child).getText(), parentElement)));
                continue;
            }
            if (child instanceof AbstractBranch) {
                RbelElement element = new RbelElement(((AbstractBranch)child).asXML().getBytes(parentElement.getElementCharset()), parentElement);
                this.buildXmlElementForNode((AbstractBranch)child, element, converter);
                childElements.add(Pair.of(((AbstractBranch)child).getName(), element));
                continue;
            }
            if (child instanceof Namespace) {
                String childXmlName = ((Namespace)child).getPrefix();
                childElements.add(Pair.of(childXmlName, converter.convertElement(((Namespace)child).getText(), parentElement)));
                continue;
            }
            if (child instanceof DefaultComment) continue;
            throw new RbelException("Could not convert XML element of type " + child.getClass().getSimpleName());
        }
        if (childElements.stream().map(Map.Entry::getKey).noneMatch(key -> key.equals(XML_TEXT_KEY))) {
            childElements.add(Pair.of(XML_TEXT_KEY, new RbelElement(new byte[0], parentElement)));
        }
        if (branch instanceof Element) {
            for (Object attribute : ((Element)branch).attributes()) {
                if (!(attribute instanceof Attribute)) {
                    throw new RbelException("Could not convert XML attribute of type " + attribute.getClass().getSimpleName());
                }
                childElements.add(Pair.of(((Attribute)attribute).getName(), converter.convertElement(((Attribute)attribute).getText(), parentElement)));
            }
        }
    }
}

