/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.protocol.voip.Rtp;
import org.jnetpcap.protocol.voip.Sdp;
import org.jnetpcap.protocol.voip.Sip;

public class TestVoip
extends TestUtils {
    private static final String SIP = "tests/test-sip-rtp.pcap";
    private static final String SIP_G711 = "tests/test-sip-rtp-g711.pcap";
    Map<Long, FileOutputStream> map = new HashMap<Long, FileOutputStream>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSip() {
        Sip sip = new Sip();
        Sdp sdp = new Sdp();
        PcapPacket pcapPacket = TestUtils.getPcapPacket(SIP, 222);
        if (pcapPacket.hasHeader(sip)) {
            System.out.printf("%s", sip);
            if (pcapPacket.hasHeader(sdp)) {
                System.out.printf("%s", sdp);
            }
        } else {
            System.out.printf(pcapPacket.toString(), new Object[0]);
        }
    }

    public void testRtpHeuristics() {
        PcapPacket pcapPacket = TestUtils.getPcapPacket(SIP_G711, 498);
        System.out.println(pcapPacket.getState().toDebugString());
        System.out.println(pcapPacket);
        System.out.flush();
        TestVoip.assertNotNull((Object)pcapPacket);
        TestVoip.assertTrue((boolean)pcapPacket.hasHeader(48));
    }

    public void SKIP_testRtpAudioExtract() throws IOException {
        Rtp rtp = new Rtp();
        try {
            for (PcapPacket object : TestUtils.getIterable(SIP_G711)) {
                TestVoip.assertNotNull((Object)object);
                if (!object.hasHeader(rtp)) continue;
                if (rtp.hasPostfix() || rtp.paddingLength() != 0) {
                    System.out.println(rtp);
                }
                FileOutputStream fileOutputStream = this.getOutput(rtp.ssrc());
                fileOutputStream.write(rtp.getPayload());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (FileOutputStream fileOutputStream : this.map.values()) {
            fileOutputStream.close();
        }
    }

    private FileOutputStream getOutput(long l) throws FileNotFoundException {
        if (this.map.containsKey(l)) {
            return this.map.get(l);
        }
        File file = new File("C:\\temp\\" + l + ".au");
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.map.put(l, fileOutputStream);
        return fileOutputStream;
    }
}

