/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.packet.VariousInMemoryPackets;

public class TestPcapPacket
extends TestCase {
    private PcapPacket packet;
    private PcapPacket packet2;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public final void testGetTotalSize() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        int n = this.packet.getTotalSize();
        TestPcapPacket.assertTrue((String)("Low bounds " + n), (n > this.packet.size() + PcapHeader.sizeof() + JPacket.State.sizeof(1) ? 1 : 0) != 0);
        TestPcapPacket.assertTrue((String)("High bounds " + n), (n < this.packet.size() + PcapHeader.sizeof() + JPacket.State.sizeof(20) ? 1 : 0) != 0);
    }

    public final void testGetTotalSizeNullPtr() {
        this.packet = new PcapPacket(JMemory.Type.POINTER);
        try {
            this.packet.getTotalSize();
            TestPcapPacket.fail((String)"expected null ptr on unitilized packet");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public final void testPcapPacketType() {
        this.packet = new PcapPacket(JMemory.Type.POINTER);
        TestPcapPacket.assertFalse((String)"packet data", (boolean)this.packet.isInitialized());
        TestPcapPacket.assertFalse((String)"packet state", (boolean)this.packet.getState().isInitialized());
        TestPcapPacket.assertFalse((String)"pcap header", (boolean)this.packet.getCaptureHeader().isInitialized());
    }

    public final void testPcapPacketInt() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.packet2 = new PcapPacket(2048);
        this.packet.transferStateAndDataTo(this.packet2);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.getState().size(), (int)this.packet2.getState().size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testPcapPacketIntUnderflow() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.packet2 = new PcapPacket(10);
        this.packet.transferStateAndDataTo(this.packet2);
        TestPcapPacket.assertTrue((String)"memory was not reallocated", (this.packet2.getAllocatedMemorySize() > 10 ? 1 : 0) != 0);
    }

    public final void testPcapPacketIntInt() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.packet2 = new PcapPacket(this.packet.size(), this.packet.getHeaderCount());
        TestPcapPacket.assertEquals((int)this.packet.getTotalSize(), (int)this.packet2.getAllocatedMemorySize());
    }

    public final void testPcapPacketIntIntUnderflow() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.packet2 = new PcapPacket(10, 1);
        this.packet.transferStateAndDataTo(this.packet2);
        TestPcapPacket.assertTrue((String)"memory was not reallocated", (this.packet2.getAllocatedMemorySize() > 10 ? 1 : 0) != 0);
    }

    public final void testPcapPacketByteBufferDirect() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.packet.getTotalSize());
        this.packet.transferStateAndDataTo(byteBuffer);
        byteBuffer.flip();
        this.packet2 = new PcapPacket(byteBuffer);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.state.size(), (int)this.packet2.state.size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testPcapPacketByteBufferArray() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.packet.getTotalSize());
        this.packet.transferStateAndDataTo(byteBuffer);
        byteBuffer.flip();
        this.packet2 = new PcapPacket(byteBuffer);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.state.size(), (int)this.packet2.state.size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testPcapPacketByteBufferOverflow() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.packet.getTotalSize() - 1);
        try {
            this.packet.transferStateAndDataTo(byteBuffer);
            TestPcapPacket.fail((String)"expected undeflow exception");
        }
        catch (BufferOverflowException bufferOverflowException) {
        }
        catch (Exception exception) {
            TestPcapPacket.fail((String)("expected overflow exception but got " + exception.getClass().getSimpleName()));
        }
    }

    public final void testPcapPacketJBuffer() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        JBuffer jBuffer = new JBuffer(this.packet.getTotalSize());
        this.packet.transferStateAndDataTo(jBuffer);
        this.packet2 = new PcapPacket(jBuffer);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.state.size(), (int)this.packet2.state.size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testPcapPacketPcapPacket() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.packet2 = new PcapPacket(this.packet);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.state.size(), (int)this.packet2.state.size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testGetCaptureHeader() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        PcapHeader pcapHeader = this.packet.getCaptureHeader();
        TestPcapPacket.assertEquals((long)1075238237L, (long)pcapHeader.seconds());
        TestPcapPacket.assertEquals((long)192611000L, (long)pcapHeader.nanos());
        TestPcapPacket.assertEquals((int)114, (int)pcapHeader.caplen());
        TestPcapPacket.assertEquals((int)114, (int)pcapHeader.wirelen());
        TestPcapPacket.assertEquals((long)1075238237192L, (long)pcapHeader.timestampInMillis());
    }

    public final void testTransferToPcapPacket() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.packet2 = new PcapPacket(JMemory.Type.POINTER);
        this.packet.transferStateAndDataTo(this.packet2);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.state.size(), (int)this.packet2.state.size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testPcapPacketByteArray() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        byte[] byArray = new byte[this.packet.getTotalSize()];
        this.packet.transferStateAndDataTo(byArray);
        this.packet2 = new PcapPacket(byArray);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.state.size(), (int)this.packet2.state.size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testPcapPacketPcapHeaderJBuffer() {
        this.packet = TestUtils.getPcapPacket("tests/test-l2tp.pcap", 0);
        this.packet2 = new PcapPacket(this.packet.getCaptureHeader(), this.packet);
        TestPcapPacket.assertEquals((int)this.packet.size(), (int)this.packet2.size());
        TestPcapPacket.assertEquals((int)this.packet.getCaptureHeader().size(), (int)this.packet2.getCaptureHeader().size());
    }

    public final void testPcapHeader() {
        JBuffer jBuffer = new JBuffer(VariousInMemoryPackets.PACKET_1);
        PcapHeader pcapHeader = new PcapHeader(jBuffer.size(), jBuffer.size());
        PcapPacket pcapPacket = new PcapPacket(JMemory.POINTER);
        pcapPacket.peer(jBuffer);
        pcapPacket.getCaptureHeader().peerTo(pcapHeader, 0);
        pcapPacket.scan(1);
        System.out.println(pcapPacket);
    }
}

