/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.header;

import java.util.EnumSet;
import java.util.Set;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeaderMap;
import org.jnetpcap.packet.JHeaderType;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.Bind;
import org.jnetpcap.packet.annotate.BindingVariable;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.FieldSetter;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.protocol.lan.Ethernet;
import org.jnetpcap.protocol.lan.IEEESnap;
import org.jnetpcap.protocol.network.Ip4;

@Header(name="ip4", nicname="ip")
public class MyHeader
extends JHeaderMap<MyHeader> {
    public static final int DIFF_CODEPOINT = 252;
    public static final int DIFF_ECE = 1;
    public static final int DIFF_ECT = 2;
    public static final int FLAG_DONT_FRAGMENT = 2;
    public static final int FLAG_MORE_FRAGMENTS = 1;
    public static final int FLAG_RESERVED = 4;
    public static final int ID = 2;
    private int hashcode;

    @Bind(to=Ethernet.class)
    public static boolean bindToEthernet(JPacket jPacket, Ethernet ethernet) {
        return ethernet.type() == 2048;
    }

    @Bind(to=IEEESnap.class)
    public static boolean bindToSnap(JPacket jPacket, IEEESnap iEEESnap) {
        return iEEESnap.pid() == 2048;
    }

    @HeaderLength
    public static int getHeaderLength(JBuffer jBuffer, int n) {
        return (jBuffer.getUByte(n) & 0xF) * 4;
    }

    @Field(offset=80, length=16, format="%x")
    public int checksum() {
        return this.getUShort(10);
    }

    @FieldSetter
    public void checksum(int n) {
        this.setUShort(10, n);
    }

    @BindingVariable(value=BindingVariable.MatchType.FUNCTION)
    public boolean checkType(int n) {
        return this.type() == n && this.offset() == 0;
    }

    public void clearFlags(int n) {
        int n2 = this.getUByte(6);
        this.setUByte(6, n2 &= ~(n << 5));
    }

    @Override
    protected void decodeHeader() {
        this.optionsBitmap = 0L;
        this.hashcode = this.id() << 16 ^ this.sourceToInt() ^ this.destinationToInt() ^ this.type();
        System.out.printf("offset=%d, %s", this.getOffset(), this.toHexdump());
        int n = this.hlen() * 4;
        for (int i = 20; i < n; ++i) {
            int n2 = this.getUByte(i) & 0x1F;
            this.optionsOffsets[n2] = i;
            this.optionsBitmap |= (long)(1 << n2);
            switch (IpOption.OptionCode.valueOf(n2)) {
                case NO_OP: {
                    this.optionsLength[n2] = 1;
                    break;
                }
                case END_OF_OPTION_LIST: {
                    this.optionsLength[n2] = n - i;
                    i = n;
                    break;
                }
                default: {
                    int n3 = this.getUByte(i + 1);
                    i += n3;
                    this.optionsLength[n2] = n3;
                }
            }
            System.out.printf("i=%d id=%d bitmap=0x%X length=%d\n", i, n2, this.optionsBitmap, this.optionsLength[n2]);
        }
    }

    @Field(offset=128, length=32, format="#ip4#")
    public byte[] destination() {
        return this.getByteArray(16, 4);
    }

    @FieldSetter
    public void destination(byte[] byArray) {
        this.setByteArray(12, byArray);
    }

    public byte[] destinationToByteArray(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("address must be 4 byte long");
        }
        return this.getByteArray(16, byArray);
    }

    public int destinationToInt() {
        return this.getInt(16);
    }

    @Field(offset=48, length=3, format="%x")
    public int flags() {
        return this.getUByte(6) >> 5;
    }

    @FieldSetter
    public void flags(int n) {
        int n2 = this.getUByte(6) & 0x1F;
        this.setUByte(6, n2 |= n << 5);
    }

    @Field(parent="flags", offset=1, length=1, display="do not fragment")
    public int flags_DF() {
        return (this.flags() & 2) >> 1;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_DFDescription() {
        return this.flags_DF() > 0 ? "set" : "not set";
    }

    @Field(parent="flags", offset=0, length=1, display="more fragments", nicname="M")
    public int flags_MF() {
        return (this.flags() & 1) >> 2;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_MFDescription() {
        return this.flags_MF() > 0 ? "set" : "not set";
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Field(offset=4, length=4, format="%d")
    public int hlen() {
        return this.getUByte(0) & 0xF;
    }

    @FieldSetter
    public void hlen(int n) {
        int n2 = this.getUByte(0) & 0xF0;
        this.setUByte(0, n2 |= n & 0xF);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String hlenDescription() {
        String string = "" + this.hlen() + " * 4 = " + this.hlen() * 4 + " bytes";
        return this.hlen() == 5 ? string + ", No Ip Options" : string + ", Ip Options Present";
    }

    @Field(offset=32, length=16, format="%x")
    public int id() {
        return this.getUShort(4);
    }

    @FieldSetter
    public void id(int n) {
        this.setUShort(4, n);
    }

    @Field(offset=16, length=16, format="%d")
    public int length() {
        return this.getUShort(2);
    }

    @FieldSetter
    public void length(int n) {
        this.setUShort(2, n);
    }

    @Field(offset=51, length=13, format="%d")
    public int offset() {
        return this.getUShort(6) & 0x1FFF;
    }

    @FieldSetter
    public void offset(int n) {
        int n2 = this.getUShort(6) & 0xFFFFE000;
        this.setUShort(6, n2 |= n & 0x1FFF);
    }

    @Field(offset=96, length=32, format="#ip4#")
    public byte[] source() {
        return this.getByteArray(12, 4);
    }

    @FieldSetter
    public void source(byte[] byArray) {
        this.setByteArray(12, byArray);
    }

    public byte[] sourceToByteArray(byte[] byArray) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("address must be 4 byte long");
        }
        return this.getByteArray(12, byArray);
    }

    public int sourceToInt() {
        return this.getInt(12);
    }

    @Field(offset=8, length=8, format="%x", display="diffserv")
    public int tos() {
        return this.getUByte(1);
    }

    @FieldSetter
    public void tos(int n) {
        this.setUByte(1, n);
    }

    @Field(parent="tos", offset=2, length=6, display="code point")
    public int tos_Codepoint() {
        return (this.tos() & 0xFC) >> 2;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String tos_CodepointDescription() {
        return this.tos_Codepoint() > 0 ? "code point " + this.tos_Codepoint() : "not set";
    }

    @Field(parent="tos", offset=0, length=1, display="ECE bit")
    public int tos_ECE() {
        return (this.tos() & 1) >> 0;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String tos_ECEDescription() {
        return this.tos_ECE() > 0 ? "set" : "not set";
    }

    @Field(parent="tos", offset=1, length=1, display="ECN bit")
    public int tos_ECN() {
        return (this.tos() & 2) >> 1;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String tos_ECNDescription() {
        return this.tos_ECN() > 0 ? "set" : "not set";
    }

    @Field(offset=64, length=8, format="%d", description="time to live")
    public int ttl() {
        return this.getUByte(8);
    }

    @FieldSetter
    public void ttl(int n) {
        this.setUByte(8, n);
    }

    @Field(offset=72, length=8, format="%d")
    public int type() {
        return this.getUByte(9);
    }

    @FieldSetter
    public void type(int n) {
        this.setUByte(9, n);
    }

    public void type(Ip4Type ip4Type) {
        this.setUByte(9, ip4Type.typeValues[0]);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String typeDescription() {
        return "next: " + Ip4Type.toString(this.type());
    }

    public Ip4Type typeEnum() {
        return Ip4Type.valueOf(this.type());
    }

    @Field(offset=0, length=4, format="%d")
    public int version() {
        return this.getUByte(0) >> 4;
    }

    @FieldSetter
    public void version(int n) {
        this.setUByte(0, this.hlen() | n << 4);
    }

    @Header(id=4)
    public static class Timestamp
    extends IpOption {
        public static final int FLAG_TIMESTAMP_WITH_IP = 1;
        public static final int FLAG_TIMESTAMPS_PRESPECIFIED = 2;
        public static final int MASK_FLAGS = 15;
        public static final int MASK_OVERFLOW = 240;

        @HeaderLength
        public static int headerLength(JBuffer jBuffer, int n) {
            return jBuffer.getUByte(1);
        }

        public byte[] address(int n) {
            if ((this.flags() & 1) == 0) {
                return null;
            }
            return this.getByteArray(n * 4 + 4, 4);
        }

        @Dynamic(value=Field.Property.LENGTH)
        public int entriesLength() {
            return (this.length() - 4) * 8;
        }

        @Field(offset=32, format="%s")
        public Entry[] entries() {
            int n = this.flags();
            if ((n & 1) == 0) {
                return this.entriesTimestampOnly();
            }
            return this.entriesWithIp();
        }

        private Entry[] entriesTimestampOnly() {
            int n = this.length() - 4;
            Entry[] entryArray = new Entry[n / 4];
            for (int i = 4; i < n; i += 8) {
                Entry entry = entryArray[i / 8];
                entry.address = this.getByteArray(i, 4);
                entry.timestamp = this.getUInt(i + 4);
            }
            return entryArray;
        }

        private Entry[] entriesWithIp() {
            int n = this.length() - 4;
            Entry[] entryArray = new Entry[n / 4];
            for (int i = 4; i < n; i += 4) {
                Entry entry = entryArray[i / 4];
                entry.timestamp = this.getUInt(i + 4);
            }
            return entryArray;
        }

        @Field(offset=28, length=4)
        public int flags() {
            return this.getUByte(3) & 0xF;
        }

        @FieldSetter
        public void flags(int n) {
            this.setUByte(3, n & 0xF);
        }

        public Set<Flag> flagsEnum() {
            EnumSet<Flag> enumSet = EnumSet.noneOf(Flag.class);
            int n = this.flags();
            if ((n & 1) == 1) {
                enumSet.add(Flag.TIMESTAMP_WITH_IP);
            }
            if ((n & 2) == 2) {
                enumSet.add(Flag.TIMESTAMPS_PRESPECIFIED);
            }
            return enumSet;
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Field(offset=16, length=16)
        public int offset() {
            return this.getUByte(2);
        }

        @FieldSetter
        public void offset(int n) {
            this.setUByte(2, n);
        }

        @Field(offset=24, length=4)
        public int overflow() {
            return (this.getUByte(3) & 0xF0) >> 4;
        }

        @FieldSetter
        public void overflow(int n) {
            this.setUByte(3, n << 4 | this.flags());
        }

        public long timestamp(int n) {
            if ((this.flags() & 1) == 0) {
                return this.getUInt(n * 4 + 4);
            }
            return this.getUInt(n * 4 + 8);
        }

        public int timestampsCount() {
            if ((this.flags() & 1) == 0) {
                return (this.length() - 4) / 4;
            }
            return (this.length() - 4) / 8;
        }

        public static enum Flag {
            TIMESTAMP_WITH_IP,
            TIMESTAMPS_PRESPECIFIED;

        }

        public static class Entry {
            public byte[] address;
            public long timestamp;
        }
    }

    @Header(id=9)
    public static class StrictSourceRoute
    extends Routing {
    }

    @Header(id=8)
    public static class StreamId
    extends IpOption {
        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Field(offset=16, length=16, format="%x")
        public int streamId() {
            return this.getUShort(2);
        }

        @FieldSetter
        public void streamId(int n) {
            this.setUShort(2, n);
        }
    }

    @Header(id=2)
    public static class Security
    extends IpOption {
        @Field(offset=32, length=16)
        public int compartments() {
            return this.getUShort(4);
        }

        @FieldSetter
        public void compartments(int n) {
            this.setUShort(4, n);
        }

        @Field(offset=64, length=24)
        public int control() {
            return this.getUShort(8) << 8 | this.getUByte(10);
        }

        @FieldSetter
        public void control(int n) {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Field(offset=48, length=16)
        public int handling() {
            return this.getUShort(6);
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Field(offset=16, length=16)
        public int security() {
            return this.getUShort(2);
        }

        @FieldSetter
        public void security(int n) {
            this.setUShort(2, n);
        }

        public void security(SecurityType securityType) {
            this.security(securityType.type);
        }

        public SecurityType securityEnum() {
            return SecurityType.valueOf(this.security());
        }

        public static enum SecurityType {
            CONFIDENTIAL(61749),
            EFTO(30874),
            MMMM(48205),
            PROG(24102),
            RESTRICTED(44819),
            SECRET(55176),
            UNCLASSIFIED(0);

            private final int type;

            public static SecurityType valueOf(int n) {
                for (SecurityType securityType : SecurityType.values()) {
                    if (securityType.getType() != n) continue;
                    return securityType;
                }
                return null;
            }

            private SecurityType(int n2) {
                this.type = n2;
            }

            public final int getType() {
                return this.type;
            }
        }
    }

    public static abstract class Routing
    extends IpOption {
        @FieldSetter
        public void address(byte[][] byArray) {
            for (int i = 0; i < byArray.length; ++i) {
                this.address(i, byArray[i]);
            }
        }

        public byte[] address(int n) {
            return this.getByteArray(n * 4 + 3, 4);
        }

        public void address(int n, byte[] byArray) {
            this.setByteArray(n * 4 + 3, byArray);
        }

        @Field(offset=24, length=0, format="#ip4[]#")
        public byte[][] addressArray() {
            byte[][] byArrayArray = new byte[this.addressCount()][];
            for (int i = 0; i < this.addressCount(); ++i) {
                byArrayArray[i] = this.address(i);
            }
            return byArrayArray;
        }

        public int addressCount() {
            return (this.length() - 3) / 4;
        }

        @Field(offset=8, length=8)
        public int length() {
            return this.getUByte(1);
        }

        @FieldSetter
        public void length(int n) {
            this.setUByte(1, n);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String lengthDescription() {
            return "(" + this.length() + " - 3)/" + 4 + " = " + this.addressCount() + " routes";
        }

        @Field(offset=16, length=8)
        public int offset() {
            return this.getUByte(2);
        }

        @FieldSetter
        public void offset(int n) {
            this.setUByte(2, n);
        }

        @Dynamic(value=Field.Property.DESCRIPTION)
        public String offsetDescription() {
            return "offset points at route #" + (this.offset() / 4 - 1) + "";
        }
    }

    @Header(id=7)
    public static class RecordRoute
    extends Routing {
    }

    @Header(id=1)
    public static class NoOp
    extends IpOption {
    }

    @Header(id=3)
    public static class LooseSourceRoute
    extends Routing {
    }

    public static abstract class IpOption
    extends JSubHeader<Ip4> {
        @HeaderLength
        public static int headerLength(JBuffer jBuffer, int n) {
            return jBuffer.getUByte(1);
        }

        @Field(offset=0, length=3, format="%d")
        public int code() {
            return this.getUByte(0) & 0x1F;
        }

        @FieldSetter
        public void code(int n) {
            this.setUByte(0, this.code() & 0xE0 | n & 0x1F);
        }

        public OptionCode codeEnum() {
            return OptionCode.values()[this.getUByte(0) & 0x1F];
        }

        public void optionCode(OptionCode optionCode) {
            this.code(optionCode.ordinal());
        }

        public static enum OptionCode {
            END_OF_OPTION_LIST(0),
            LOOSE_SOURCE_ROUTE(3),
            NO_OP(1),
            RECORD_ROUTE(7),
            SECURITY(2),
            STREAM_ID(8),
            STRICT_SOURCE_ROUTE(9),
            TIMESTAMP(4),
            UNASSIGNED1(5),
            UNASSIGNED2(6);

            public final int id;

            private OptionCode(int n2) {
                this.id = n2;
            }

            public static OptionCode valueOf(int n) {
                for (OptionCode optionCode : OptionCode.values()) {
                    if (optionCode.id != n) continue;
                    return optionCode;
                }
                return null;
            }
        }
    }

    public static enum Ip4Type implements JHeaderType
    {
        ICMP("icmp", 1),
        TCP("tcp", 6),
        UDP("udp", 17);

        private final String description;
        private final int[] typeValues;

        public static String toString(int n) {
            for (Ip4Type ip4Type : Ip4Type.values()) {
                for (int n2 : ip4Type.typeValues) {
                    if (n2 != n) continue;
                    return ip4Type.description;
                }
            }
            return Integer.toString(n);
        }

        public static Ip4Type valueOf(int n) {
            for (Ip4Type ip4Type : Ip4Type.values()) {
                for (int n2 : ip4Type.typeValues) {
                    if (n2 != n) continue;
                    return ip4Type;
                }
            }
            return null;
        }

        private Ip4Type(int ... nArray) {
            this.typeValues = nArray;
            this.description = this.name().toLowerCase();
        }

        private Ip4Type(String string2, int ... nArray) {
            this.typeValues = nArray;
            this.description = string2;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final int[] getTypeValues() {
            return this.typeValues;
        }
    }
}

