/*
 * Decompiled with CFR 0.152.
 */
package j2html.tags;

import j2html.Config;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Scanner;

public class InlineStaticResource {
    public static ContainerTag get(String path, TargetFormat format) {
        String fileString = InlineStaticResource.getFileAsString(path);
        switch (format) {
            case CSS_MIN: {
                return TagCreator.style().with((DomContent)TagCreator.rawHtml(Config.cssMinifier.minify(fileString)));
            }
            case JS_MIN: {
                return TagCreator.script().with((DomContent)TagCreator.rawHtml(Config.jsMinifier.minify(fileString)));
            }
            case CSS: {
                return TagCreator.style().with((DomContent)TagCreator.rawHtml(fileString));
            }
            case JS: {
                return TagCreator.script().with((DomContent)TagCreator.rawHtml(fileString));
            }
        }
        throw new RuntimeException("Invalid target format");
    }

    public static String getFileAsString(String path) {
        try {
            return InlineStaticResource.streamToString(InlineStaticResource.class.getResourceAsStream(path));
        }
        catch (Exception expected) {
            try {
                return InlineStaticResource.streamToString(new FileInputStream(path));
            }
            catch (Exception exception) {
                throw new RuntimeException("Couldn't find file with path='" + path + "'");
            }
        }
    }

    private static String streamToString(InputStream inputStream) {
        Scanner s2 = new Scanner(inputStream).useDelimiter("\\A");
        return s2.hasNext() ? s2.next() : "";
    }

    public static enum TargetFormat {
        CSS_MIN,
        CSS,
        JS_MIN,
        JS;

    }
}

