/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.key;

import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.key.RbelKey;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelKeyManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelKeyManager.class);
    public static final RbelConverterPlugin RBEL_IDP_TOKEN_KEY_LISTENER = (element, converter) -> Optional.ofNullable(element).filter(el -> el.hasFacet(RbelJsonFacet.class)).filter(el -> el.getKey().filter(key -> key.equals("token_key")).isPresent()).flatMap(el -> el.getFirst("content")).map(RbelElement::getRawStringContent).map(tokenB64 -> {
        try {
            return Base64.getDecoder().decode((String)tokenB64);
        }
        catch (Exception e) {
            return null;
        }
    }).filter(Objects::nonNull).map(tokenKeyBytes -> new SecretKeySpec((byte[])tokenKeyBytes, "AES")).ifPresent(aesKey -> converter.getRbelKeyManager().addKey("token_key", (Key)aesKey, 110));
    private final List<RbelKey> keyList = new ArrayList<RbelKey>();

    public RbelKeyManager addAll(Map<String, RbelKey> keys) {
        this.keyList.addAll(keys.values());
        return this;
    }

    public void addKey(RbelKey rbelKey) {
        if (rbelKey.getKey() == null) {
            return;
        }
        if (this.keyIsPresentInList(rbelKey.getKey())) {
            log.debug("Skipping adding key: Key is already known!");
        }
        this.keyList.add(rbelKey);
    }

    public RbelKey addKey(String keyId, Key key, int precedence) {
        if (this.keyIsPresentInList(key)) {
            log.debug("Skipping adding key: Key is already known!");
        }
        RbelKey rbelKey = RbelKey.builder().keyName(keyId).key(key).precedence(precedence).build();
        this.keyList.add(rbelKey);
        log.info("Added key {} (Now there are {} keys known)", (Object)keyId, (Object)this.keyList.size());
        return rbelKey;
    }

    private boolean keyIsPresentInList(Key key) {
        return this.keyList.stream().map(RbelKey::getKey).map(Key::getEncoded).filter(oldKey -> Arrays.equals(oldKey, key.getEncoded())).findAny().isPresent();
    }

    public Stream<RbelKey> getAllKeys() {
        return this.keyList.stream().sorted(Comparator.comparing(RbelKey::getPrecedence));
    }

    public Optional<RbelKey> findCorrespondingPrivateKey(String rbelKey) {
        return this.getAllKeys().filter(candidate -> candidate.getMatchingPublicKey().isPresent()).filter(candidate -> Objects.equals(candidate.getMatchingPublicKey().get().getKeyName(), rbelKey)).findFirst();
    }

    public Optional<RbelKey> findKeyByName(String keyName) {
        return this.getAllKeys().filter(candidate -> candidate.getKeyName() != null).filter(candidate -> candidate.getKeyName().equals(keyName)).findFirst();
    }
}

