/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.exceptions.RbelConversionException;
import de.gematik.rbellogger.exceptions.RbelHostnameFormatException;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.commons.validator.routines.UrlValidator;

public class RbelHostname {
    private final String hostname;
    private final int port;

    public static Optional<RbelHostname> fromString(String value) {
        if (StringUtils.isBlank(value)) {
            return Optional.empty();
        }
        if (value.contains(":")) {
            String[] hostnameValues = value.split(":");
            int port = Integer.parseInt(hostnameValues[1]);
            RbelHostname.checkIfHostnameIsValid(hostnameValues[0]);
            RbelHostname.checkIfPortIsNegative(port);
            try {
                return Optional.ofNullable(RbelHostname.builder().hostname(hostnameValues[0]).port(port).build());
            }
            catch (Exception e) {
                throw new RbelHostnameFormatException("Unable to parse hostname: '" + value + "'", e);
            }
        }
        RbelHostname.checkIfHostnameIsValid(value);
        return Optional.ofNullable(RbelHostname.builder().hostname(value).build());
    }

    private static void checkIfHostnameIsValid(String hostname) {
        if (hostname.contains(".")) {
            InetAddressValidator validator = InetAddressValidator.getInstance();
            if (!validator.isValid(hostname)) {
                throw new RbelHostnameFormatException("The given IP address is invalid. Please check your configuration.");
            }
        } else {
            DomainValidator validator = DomainValidator.getInstance(true);
            if (!validator.isValid(hostname)) {
                throw new RbelHostnameFormatException("The given hostname is invalid. Please check your configuration.");
            }
        }
    }

    private static void checkIfPortIsNegative(int port) {
        if (port < 0) {
            throw new RbelHostnameFormatException("The given port '" + port + "' is invalid. Please check your configuration.");
        }
    }

    public static Optional<Object> generateFromUrl(String url) {
        if (StringUtils.isEmpty(url)) {
            return Optional.empty();
        }
        RbelHostname.checkIfUrlIsValid(url);
        try {
            URI uri = new URI(url);
            if (uri.getPort() > 0) {
                return Optional.of(new RbelHostname(uri.getHost(), uri.getPort()));
            }
            if ("http".equals(uri.getScheme())) {
                return Optional.of(new RbelHostname(uri.getHost(), 80));
            }
            if ("https".equals(uri.getScheme())) {
                return Optional.of(new RbelHostname(uri.getHost(), 443));
            }
            throw new RbelConversionException("Could not parse Hostname from '" + url + "'");
        }
        catch (Exception e) {
            throw new RbelConversionException("Could not parse Hostname from '" + url + "'");
        }
    }

    private static void checkIfUrlIsValid(String url) {
        UrlValidator urlValidator = new UrlValidator(8L);
        if (!urlValidator.isValid(url)) {
            throw new RbelConversionException("The given URL is invalid. Please check your configuration.");
        }
    }

    public String toString() {
        if (this.port > 0) {
            return this.hostname + ":" + this.port;
        }
        return this.hostname;
    }

    @Generated
    public static RbelHostnameBuilder builder() {
        return new RbelHostnameBuilder();
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelHostname)) {
            return false;
        }
        RbelHostname other = (RbelHostname)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        return this.getPort() == other.getPort();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelHostname;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        result = result * 59 + this.getPort();
        return result;
    }

    @ConstructorProperties(value={"hostname", "port"})
    @Generated
    public RbelHostname(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    @Generated
    public static class RbelHostnameBuilder {
        @Generated
        private String hostname;
        @Generated
        private int port;

        @Generated
        RbelHostnameBuilder() {
        }

        @Generated
        public RbelHostnameBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public RbelHostnameBuilder port(int port) {
            this.port = port;
            return this;
        }

        @Generated
        public RbelHostname build() {
            return new RbelHostname(this.hostname, this.port);
        }

        @Generated
        public String toString() {
            return "RbelHostname.RbelHostnameBuilder(hostname=" + this.hostname + ", port=" + this.port + ")";
        }
    }
}

