/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol;

import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.TestUtils;
import org.jnetpcap.protocol.sigtran.Sctp;
import org.junit.Test;

public class TestSctp
extends TestCase {
    PrintStream out = TestUtils.DISCARD;
    private static final String FILE = "tests/test-sctp-www.pcap";

    public void testSctpHeader() throws IOException {
        Sctp sctp = new Sctp();
        JPacket.getDefaultScanner().setFrameNumber(1L);
        int n = 1;
        for (PcapPacket pcapPacket : TestUtils.getIterable(FILE)) {
            this.out.println(pcapPacket);
            TestCase.assertTrue((String)"", (boolean)pcapPacket.hasHeader(32));
            TestCase.assertTrue((String)"", (boolean)pcapPacket.hasHeader(sctp));
            if (n++ != 76) continue;
            this.out.println(pcapPacket.getState().toDebugString());
        }
    }

    @Test
    public void testPacketFilterByType() {
        JPacket.getDefaultScanner().setFrameNumber(1L);
        for (PcapPacket pcapPacket : TestUtils.getIterable(FILE)) {
            for (JHeaderChecksum jHeaderChecksum : pcapPacket.filterByType(JHeaderChecksum.class)) {
                JHeader jHeader = (JHeader)((Object)jHeaderChecksum);
                TestSctp.assertNotNull((Object)jHeader);
                this.out.printf("#%d %10s sum=%08X%n", jHeader.getPacket().getFrameNumber(), jHeader.getName(), jHeaderChecksum.checksum());
            }
        }
    }
}

