/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.renderer;

import de.gematik.rbellogger.converter.RbelValueShader;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelAsn1Facet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.BinaryClassifier;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelHtmlRenderer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelHtmlRenderer.class);
    private static final List<RbelHtmlFacetRenderer> htmlRenderer = new ArrayList<RbelHtmlFacetRenderer>();
    private final RbelValueShader rbelValueShader;
    private boolean renderAsn1Objects = false;
    private boolean renderNestedObjectsWithoutFacetRenderer = false;
    private String title = "RBelLogger";
    private String subTitle = "<p>The [R]everse [B]ridle [E]vent [L]ogger pays tribute to the fact that many agile projects' specifications, alas somewhat complete, lack specificality. Using PoCs most of the time does not resolve this as the code is not well enough documented and communication between nodes is not observable or logged in a well enough readable manner.</p> <p>This is where the RBeL Logger comes into play.</p> <p>Attaching it to a network, RestAssured or Wiremock interface or instructing it to read from a recorded PCAP file, produces this shiny communication log supporting Plain HTTP, JSON, JWT and even JWE!</p>";

    public RbelHtmlRenderer(RbelValueShader rbelValueShader) {
        this.rbelValueShader = rbelValueShader;
    }

    public RbelHtmlRenderer() {
        this.rbelValueShader = new RbelValueShader();
    }

    public static String render(List<RbelElement> elements) {
        return RbelHtmlRenderer.render(elements, new RbelValueShader());
    }

    public static String render(List<RbelElement> elements, RbelValueShader valueShader) {
        return new RbelHtmlRenderer(valueShader).performRendering(elements);
    }

    public static ContainerTag collapsibleCard(ContainerTag title, ContainerTag body) {
        return ((ContainerTag)TagCreator.div().withClass("container page-break mx-3 my-6")).with((DomContent)((ContainerTag)TagCreator.div().withClass("card full-width")).with(((ContainerTag)TagCreator.header().withClass("card-header")).with((DomContent)((ContainerTag)TagCreator.div().withClass("card-header-title card-toggle")).with((DomContent)title)), ((ContainerTag)TagCreator.div().withClass("card-content")).with((DomContent)TagCreator.div().with((DomContent)body))));
    }

    public static DomContent showContentButtonAndDialog(RbelElement el) {
        String id = "dialog" + RandomStringUtils.randomAlphanumeric(20);
        return TagCreator.span().with(((ContainerTag)((ContainerTag)TagCreator.a().withClass("button modal-button is-pulled-right mx-3")).attr("data-target", id)).with((DomContent)((ContainerTag)TagCreator.span().withClass("icon is-small")).with((DomContent)TagCreator.i().withClass("fas fa-align-left"))), ((ContainerTag)((ContainerTag)TagCreator.div().withClass("modal")).withId(id)).with(new DomContent[]{TagCreator.div().withClass("modal-background"), ((ContainerTag)TagCreator.div().withClass("modal-content")).with((DomContent)((ContainerTag)TagCreator.article().withClass("message")).with(((ContainerTag)TagCreator.div().withClass("message-header")).with(new DomContent[]{TagCreator.p("Raw content of " + el.findNodePath()), ((ContainerTag)TagCreator.button().withClass("delete")).attr("aria-label", "delete")}), ((ContainerTag)TagCreator.div().withClass("message-body")).with((DomContent)TagCreator.pre(BinaryClassifier.isBinary(el.getRawContent()) ? Hex.toHexString(el.getRawContent()) : el.getRawStringContent()).withStyle("white-space: pre-wrap;word-wrap: break-word;")))), ((ContainerTag)TagCreator.button().withClass("modal-close is-large")).attr("aria-label", "close")}));
    }

    public static void registerFacetRenderer(RbelHtmlFacetRenderer rbelFacetRenderer) {
        htmlRenderer.add(rbelFacetRenderer);
    }

    public String doRender(List<RbelElement> elements) {
        return this.performRendering(elements);
    }

    private String performRendering(List<RbelElement> elements) {
        RbelHtmlRenderingToolkit renderingToolkit = new RbelHtmlRenderingToolkit(this);
        return renderingToolkit.renderDocument(new ArrayList<RbelElement>(elements));
    }

    public Optional<ContainerTag> convert(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
        if (element.getFacets().isEmpty() && ArrayUtils.isEmpty(element.getRawContent())) {
            return Optional.empty();
        }
        return htmlRenderer.stream().filter(renderer -> this.renderAsn1Objects || !renderer.getClass().getName().startsWith(RbelAsn1Facet.class.getName())).filter(renderer -> renderer.checkForRendering(element)).map(renderer -> renderer.performRendering(element, key, renderingToolkit)).findAny();
    }

    public String getEmptyPage() {
        return this.performRendering(List.of());
    }

    @Generated
    public RbelValueShader getRbelValueShader() {
        return this.rbelValueShader;
    }

    @Generated
    public boolean isRenderAsn1Objects() {
        return this.renderAsn1Objects;
    }

    @Generated
    public boolean isRenderNestedObjectsWithoutFacetRenderer() {
        return this.renderNestedObjectsWithoutFacetRenderer;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getSubTitle() {
        return this.subTitle;
    }

    @Generated
    public void setRenderAsn1Objects(boolean renderAsn1Objects) {
        this.renderAsn1Objects = renderAsn1Objects;
    }

    @Generated
    public void setRenderNestedObjectsWithoutFacetRenderer(boolean renderNestedObjectsWithoutFacetRenderer) {
        this.renderNestedObjectsWithoutFacetRenderer = renderNestedObjectsWithoutFacetRenderer;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }
}

