/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

public class RbelJsonFacet
implements RbelFacet {
    private final JsonElement jsonElement;

    @Override
    public List<Map.Entry<String, RbelElement>> getChildElements() {
        return List.of();
    }

    @ConstructorProperties(value={"jsonElement"})
    @Generated
    RbelJsonFacet(JsonElement jsonElement) {
        this.jsonElement = jsonElement;
    }

    @Generated
    public static RbelJsonFacetBuilder builder() {
        return new RbelJsonFacetBuilder();
    }

    @Generated
    public RbelJsonFacetBuilder toBuilder() {
        return new RbelJsonFacetBuilder().jsonElement(this.jsonElement);
    }

    @Generated
    public JsonElement getJsonElement() {
        return this.jsonElement;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelJsonFacet)) {
            return false;
        }
        RbelJsonFacet other = (RbelJsonFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonElement this$jsonElement = this.getJsonElement();
        JsonElement other$jsonElement = other.getJsonElement();
        return !(this$jsonElement == null ? other$jsonElement != null : !this$jsonElement.equals(other$jsonElement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelJsonFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonElement $jsonElement = this.getJsonElement();
        result = result * 59 + ($jsonElement == null ? 43 : $jsonElement.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelJsonFacet(jsonElement=" + this.getJsonElement() + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelJsonFacet.class) && element.getFacet(RbelRootFacet.class).filter(root -> root.getRootFacet() instanceof RbelJsonFacet).isPresent();
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                String formatedJson = RbelHtmlRenderingToolkit.GSON.toJson(renderingToolkit.shadeJson(JsonParser.parseString(element.getRawStringContent()), Optional.empty(), element));
                for (Map.Entry<UUID, RbelHtmlRenderingToolkit.JsonNoteEntry> entry : renderingToolkit.getNoteTags().entrySet()) {
                    if (formatedJson.contains(entry.getValue().getStringToMatch() + ",")) {
                        formatedJson = formatedJson.replace(entry.getValue().getStringToMatch() + ",", entry.getValue().getTagForKeyReplacement().render() + "," + entry.getValue().getTagForValueReplacement().render());
                        continue;
                    }
                    if (!formatedJson.contains(entry.getValue().getStringToMatch())) continue;
                    formatedJson = formatedJson.replace(entry.getValue().getStringToMatch(), entry.getValue().getTagForKeyReplacement().render() + entry.getValue().getTagForValueReplacement().render());
                }
                return RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-child pr-3")).with((DomContent)TagCreator.pre(new UnescapedText(formatedJson)).withClass("json")).with(renderingToolkit.convertNested(element))));
            }
        });
    }

    @Generated
    public static class RbelJsonFacetBuilder {
        @Generated
        private JsonElement jsonElement;

        @Generated
        RbelJsonFacetBuilder() {
        }

        @Generated
        public RbelJsonFacetBuilder jsonElement(JsonElement jsonElement) {
            this.jsonElement = jsonElement;
            return this;
        }

        @Generated
        public RbelJsonFacet build() {
            return new RbelJsonFacet(this.jsonElement);
        }

        @Generated
        public String toString() {
            return "RbelJsonFacet.RbelJsonFacetBuilder(jsonElement=" + this.jsonElement + ")";
        }
    }
}

