/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.network;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;

@Header
public class Arp
extends JHeader {
    private int shaOffset;
    private int spaOffset;
    private int thaOffset;
    private int tpaOffset;

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        int n2 = jBuffer.getUByte(n + 4);
        int n3 = jBuffer.getUByte(n + 5);
        return (n2 + n3) * 2 + 8;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String hardwareTypeDescription() {
        return this.hardwareTypeEnum().toString();
    }

    @Field(offset=0, length=16)
    public int hardwareType() {
        return super.getUShort(0);
    }

    public HardwareType hardwareTypeEnum() {
        return HardwareType.valueOf(this.hardwareType());
    }

    @Field(offset=16, format="%x", length=16)
    public int protocolType() {
        return super.getUShort(2);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String protocolTypeDescription() {
        return this.protocolTypeEnum().toString();
    }

    public ProtocolType protocolTypeEnum() {
        return ProtocolType.valueOf(this.protocolType());
    }

    @Field(offset=32, length=8, units="bytes", display="hardware size")
    public int hlen() {
        return super.getUByte(4);
    }

    @Field(offset=40, length=8, units="bytes", display="protocol size")
    public int plen() {
        return super.getUByte(5);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String operationDescription() {
        return this.operationEnum().toString();
    }

    @Field(offset=48, length=16, display="op code")
    public int operation() {
        return super.getUShort(6);
    }

    public OpCode operationEnum() {
        return OpCode.valueOf(this.operation());
    }

    @Field(offset=64, format="#mac#", display="sender MAC")
    public byte[] sha() {
        return super.getByteArray(this.shaOffset, this.hlen());
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int shaLength() {
        return this.hlen() * 8;
    }

    @Field(format="#ip4#", display="sender IP")
    public byte[] spa() {
        return super.getByteArray(this.spaOffset, this.plen());
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int spaOffset() {
        return this.spaOffset * 8;
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int spaLength() {
        return this.plen() * 8;
    }

    @Field(format="#mac#", display="target MAC")
    public byte[] tha() {
        return super.getByteArray(this.thaOffset, this.hlen());
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int thaOffset() {
        return this.thaOffset * 8;
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int thaLength() {
        return this.hlen() * 8;
    }

    @Field(format="#ip4#", display="target IP")
    public byte[] tpa() {
        return super.getByteArray(this.tpaOffset, this.plen());
    }

    @Dynamic(value=Field.Property.OFFSET)
    public int tpaOffset() {
        return this.tpaOffset * 8;
    }

    @Dynamic(value=Field.Property.LENGTH)
    public int tpaLength() {
        return this.plen() * 8;
    }

    protected void decodeHeader() {
        int n = this.hlen();
        int n2 = this.plen();
        this.shaOffset = 8;
        this.spaOffset = this.shaOffset + n;
        this.thaOffset = this.spaOffset + n2;
        this.tpaOffset = this.thaOffset + n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpCode {
        RESERVED1,
        REQUEST,
        REPLY,
        REQUEST_REVERSE,
        REPLY_REVERSE,
        DRARP_REQUEST,
        DRARP_REPLY,
        DRARP_ERROR,
        IN_ARP_REQUEST,
        IN_ARP_REPLY,
        ARP_NAK,
        MARS_REQUEST,
        MARS_MULTI,
        MARS_MSERV,
        MARS_JOIN,
        MARS_LEAVE,
        MARS_NAK,
        MARS_UNSERV,
        MARS_SJOIN,
        MARS_SLEAVE,
        MARS_GROUP_LIST_REQUEST,
        MARS_GROUP_LIST_REPLAY,
        MARS_REDIRECT_MAP,
        MAPOS_UNARP,
        OP_EXP1,
        OP_EXP2;


        public static OpCode valueOf(int n) {
            return OpCode.values()[n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProtocolType {
        IP(2048);

        private final int value;

        private ProtocolType(int n2) {
            this.value = n2;
        }

        public static ProtocolType valueOf(int n) {
            if (n == 2048) {
                return IP;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HardwareType {
        RESERVED1,
        ETHERNET,
        EXSPERIMENTAL_ETHERNET,
        AMATEUR_RADIO_AX_25,
        PROTEON_PRO_NET_TOKEN_RING,
        CHAOS,
        IEEE802,
        ARCNET,
        HYPERCHANNEL,
        LANSTAR,
        AUTONET_SHORT_ADDRESS,
        LOCAL_TALK,
        LOCAL_NET,
        ULTRA_LINK,
        SMDS,
        FRAME_RELAY,
        ATM1,
        SERIAL_LINE,
        ATM2,
        MIL_STD_188_220,
        METRICOM,
        IEEE1395,
        MAPOS,
        TWINAXIAL,
        EUI64,
        HIPARP,
        ISO7816_3,
        ARPSEC,
        IPSEC_TUNNEL,
        INFINIBAND,
        CAI,
        WIEGAND_INTERFACE,
        PURE_ID,
        HW_EXP1;


        public static HardwareType valueOf(int n) {
            return HardwareType.values()[n];
        }
    }
}

