/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.format;

import java.io.IOException;
import java.sql.Timestamp;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.structure.JField;

public class XmlFormatter
extends JFormatter {
    private static final String PAD = "  ";
    private static final String LT = "<";
    private static final String GT = ">";

    protected void fieldAfter(JHeader jHeader, JField jField, JFormatter.Detail detail) throws IOException {
        if (jField.getStyle() == JFormatter.Style.BYTE_ARRAY_HEX_DUMP) {
            this.decLevel();
            this.pad().format("</hexdump>\n", new Object[0]);
        } else if (jField.getStyle() == JFormatter.Style.INT_BITS) {
            // empty if block
        }
        this.decLevel();
    }

    public XmlFormatter() {
    }

    public XmlFormatter(Appendable appendable) {
        super(appendable);
    }

    public XmlFormatter(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    protected void fieldBefore(JHeader jHeader, JField jField, JFormatter.Detail detail) throws IOException {
        this.incLevel(PAD);
        if (jField.getStyle() == JFormatter.Style.BYTE_ARRAY_HEX_DUMP) {
            this.pad().format("<hexdump offset=\"%d\" length=\"%d\">", jField.getOffset(jHeader), jField.getLength(jHeader));
            this.incLevel(PAD);
            String[] stringArray = this.stylizeMultiLine(jHeader, jField, JFormatter.Style.BYTE_ARRAY_HEX_DUMP_NO_TEXT, jField.getValue(jHeader));
            this.incLevel(PAD);
            for (String string : stringArray) {
                this.pad().format("<hexline data=\"%s\"/>", string.trim());
            }
            this.decLevel();
        } else if (jField.getStyle() != JFormatter.Style.INT_BITS) {
            if (jField.getStyle() == JFormatter.Style.BYTE_ARRAY_ARRAY_IP4_ADDRESS) {
                byte[][] byArray;
                for (byte[] byArray2 : byArray = (byte[][])jField.getValue(jHeader)) {
                    String string = this.stylizeSingleLine(jHeader, jField, byArray2);
                    this.pad().format("<ip4=\"%s\" />", string);
                }
                this.incLevel(0);
            } else {
                String string = this.stylizeSingleLine(jHeader, jField, jField.getValue(jHeader));
                this.pad().format("<field name=\"%s\" value=\"%s\" offset=\"%d\" length=\"%d\"/>", jField.getName(), string, jField.getOffset(jHeader), jField.getLength(jHeader));
            }
        }
    }

    protected void headerAfter(JHeader jHeader, JFormatter.Detail detail) throws IOException {
        this.pad().format("</header>", new Object[0]);
        this.pad();
    }

    protected void headerBefore(JHeader jHeader, JFormatter.Detail detail) throws IOException {
        this.pad().format("<header name=\"%s\"", jHeader.getName());
        this.incLevel("    ");
        this.pad().format("nicname=\"%s\"", jHeader.getNicname());
        this.pad().format("classname=\"%s\"", jHeader.getClass().getCanonicalName());
        this.pad().format("offset=\"%d\"", jHeader.getOffset());
        this.pad().format("length=\"%d\">", jHeader.getLength());
        this.decLevel();
    }

    public void packetAfter(JPacket jPacket, JFormatter.Detail detail) throws IOException {
        this.decLevel();
        this.pad().format("</packet>", new Object[0]);
    }

    public void packetBefore(JPacket jPacket, JFormatter.Detail detail) throws IOException {
        this.pad().format("<packet", new Object[0]);
        this.incLevel("    ");
        this.pad().format("wirelen=\"%d\"", jPacket.getCaptureHeader().wirelen());
        this.pad().format("caplen=\"%d\"", jPacket.getCaptureHeader().caplen());
        if (this.frameIndex != -1) {
            this.pad().format("index=\"%d\"", this.frameIndex);
        }
        this.pad().format("timestamp=\"%s\"", new Timestamp(jPacket.getCaptureHeader().timestampInMillis()));
        this.pad().format("captureSeconds=\"%s\"", jPacket.getCaptureHeader().seconds());
        this.pad().format("captureNanoSeconds=\"%s\">", jPacket.getCaptureHeader().nanos());
        this.pad();
        this.decLevel();
        this.incLevel(PAD);
    }

    protected void subHeaderAfter(JHeader jHeader, JHeader jHeader2, JFormatter.Detail detail) throws IOException {
        this.headerAfter(jHeader2, detail);
        this.decLevel();
    }

    protected void subHeaderBefore(JHeader jHeader, JHeader jHeader2, JFormatter.Detail detail) throws IOException {
        this.incLevel(PAD);
        this.pad();
        this.headerBefore(jHeader2, detail);
    }
}

