/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.format;

import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.Formatter;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.structure.JField;
import org.jnetpcap.protocol.JProtocol;

public class TextFormatter
extends JFormatter {
    public static final int COL1 = 40;
    private static final String FIELD_ARRAY_FORMAT = "%37s[%d] = ";
    private static final String FIELD_FORMAT = "%40s = ";
    private static final String SEPARATOR = ": ";
    final Formatter uf = new Formatter();

    public TextFormatter() {
    }

    public TextFormatter(Appendable appendable) {
        super(appendable);
    }

    public TextFormatter(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    protected void fieldAfter(JHeader jHeader, JField jField, JFormatter.Detail detail) throws IOException {
        if (jField.getStyle() != JFormatter.Style.INT_BITS) {
            if (jField.hasSubFields()) {
                this.decLevel();
            } else if (jField.getStyle() != JFormatter.Style.BYTE_ARRAY_HEX_DUMP && jField.getStyle() != JFormatter.Style.STRING_TEXT_DUMP) {
                this.decLevel();
            }
        }
    }

    protected void fieldBefore(JHeader jHeader, JField jField, JFormatter.Detail detail) throws IOException {
        if (jField.hasSubFields()) {
            String string = this.stylizeSingleLine(jHeader, jField, jField.getValue(jHeader));
            this.pad().format("%40s = %s", jField.getDisplay(jHeader), string);
            this.incLevel(19);
        } else if (jField.getStyle() == JFormatter.Style.INT_BITS) {
            String string = this.stylizeSingleLine(jHeader, jField, jField.getValue(jHeader));
            String string2 = jField.getValueDescription(jHeader);
            long l = jField.longValue(jHeader);
            this.pad().format("%s = [%d] %s%s", string, l, jField.getDisplay(jHeader), string2 == null ? "" : SEPARATOR + string2);
        } else if (jField.getStyle() == JFormatter.Style.BYTE_ARRAY_HEX_DUMP || jField.getStyle() == JFormatter.Style.STRING_TEXT_DUMP) {
            String[] stringArray;
            this.decLevel();
            this.decLevel();
            for (String string : stringArray = this.stylizeMultiLine(jHeader, jField, jField.getValue(jHeader))) {
                this.pad().format("%s", string);
            }
        } else if (jField.getStyle() == JFormatter.Style.BYTE_ARRAY_ARRAY_IP4_ADDRESS) {
            byte[][] byArray = (byte[][])jField.getValue(jHeader);
            int n = 0;
            for (byte[] byArray2 : byArray) {
                String string = this.stylizeSingleLine(jHeader, jField, byArray2);
                this.pad().format("%37s[%d] = %s", jField.getDisplay(jHeader), n++, string);
            }
            this.incLevel(0);
        } else if (jField.getStyle() == JFormatter.Style.STRING_ARRAY) {
            String[] stringArray = (String[])jField.getValue(jHeader);
            int n = 0;
            for (String string : stringArray) {
                this.pad().format("%37s[%d] = %s", jField.getDisplay(jHeader), n++, string);
            }
        } else if (jField.getStyle() == JFormatter.Style.INT_DEC_ARRAY) {
            String[] stringArray = (String[])jField.getValue(jHeader);
            int n = 0;
            for (String string : stringArray) {
                this.pad().format("%37s[%d] = %s", jField.getDisplay(jHeader), n++, string);
            }
            this.incLevel(0);
        } else {
            boolean bl;
            Object object = jField.getValue(jHeader);
            boolean bl2 = bl = jField.getStyle() == JFormatter.Style.BYTE_ARRAY_ARRAY_IP4_ADDRESS || jField.getStyle() == JFormatter.Style.BYTE_ARRAY_IP4_ADDRESS || jField.getStyle() == JFormatter.Style.BYTE_ARRAY_IP6_ADDRESS || jField.getStyle() == JFormatter.Style.BYTE_ARRAY_DASH_ADDRESS || jField.getStyle() == JFormatter.Style.BYTE_ARRAY_COLON_ADDRESS || jField.getStyle() == JFormatter.Style.BYTE_ARRAY_DOT_ADDRESS || jField.getStyle() == JFormatter.Style.BYTE_ARRAY_OCTET_STREAM;
            if (!bl && object.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    String string = this.stylizeSingleLine(jHeader, jField, Array.get(object, i));
                    this.pad().format("%37s[%d] = %s", jField.getDisplay(jHeader), i++, string);
                }
                return;
            }
            String string = this.stylizeSingleLine(jHeader, jField, object);
            String string3 = jField.getValueDescription(jHeader);
            String string4 = jField.getUnits(jHeader);
            this.pad().format("%40s = %s", jField.getDisplay(jHeader), string);
            if (string4 != null) {
                this.out.format(" " + string4, new Object[0]);
            }
            if (string3 != null) {
                this.out.format(" [" + string3 + "]", new Object[0]);
            }
            this.incLevel(19);
        }
    }

    protected void headerAfter(JHeader jHeader, JFormatter.Detail detail) throws IOException {
        this.pad();
        this.decLevel();
        this.decLevel();
    }

    protected void headerBefore(JHeader jHeader, JFormatter.Detail detail) throws IOException {
        String string = jHeader.getNicname();
        this.incLevel(string);
        this.incLevel(SEPARATOR);
        JProtocol.Suite suite = jHeader.getAnnotatedHeader().getSuite();
        String string2 = "";
        if (suite != ProtocolSuite.OTHER) {
            string2 = "protocol suite=" + suite.name().replace('_', '/');
        }
        if (jHeader.hasDescription()) {
            this.pad().format(" ******* %s - \"%s\" - offset=%d (0x%X) length=%d %s", jHeader.getName(), jHeader.getDescription(), jHeader.getOffset(), jHeader.getOffset(), jHeader.getLength(), string2);
        } else {
            this.pad().format(" ******* %s offset=%d (0x%X) length=%d %s", jHeader.getName(), jHeader.getOffset(), jHeader.getOffset(), jHeader.getLength(), string2);
        }
        this.pad();
    }

    public void packetAfter(JPacket jPacket, JFormatter.Detail detail) throws IOException {
        if (this.frameIndex != -1) {
            this.pad().format("END OF PACKET %d", this.frameIndex);
        }
    }

    public void packetBefore(JPacket jPacket, JFormatter.Detail detail) throws IOException {
        this.incLevel("Frame:");
        this.pad();
        if (this.frameIndex != -1) {
            this.pad().format("%40s = %d", "#", this.frameIndex);
        } else {
            this.pad().format("%40s = %d", "number", jPacket.getState().getFrameNumber());
        }
        this.pad().format("%40s = %s", "timestamp", new Timestamp(jPacket.getCaptureHeader().timestampInMillis()).toString());
        this.pad().format("%40s = %d bytes", "wire length", jPacket.getCaptureHeader().wirelen());
        this.pad().format("%40s = %d bytes", "captured length", jPacket.getCaptureHeader().caplen());
        this.pad();
        this.decLevel();
    }

    protected void packetNull(JPacket jPacket, JFormatter.Detail detail) {
        this.pad().format("packet: NULL", new Object[0]);
    }

    protected void subHeaderAfter(JHeader jHeader, JHeader jHeader2, JFormatter.Detail detail) throws IOException {
    }

    protected void subHeaderBefore(JHeader jHeader, JHeader jHeader2, JFormatter.Detail detail) throws IOException {
        this.pad();
        this.pad().format("+ %s: offset=%d length=%d", jHeader2.getName(), jHeader2.getOffset(), jHeader2.getLength());
    }
}

