/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class RbelHttpResponseWriter
implements RbelElementWriter {
    @Override
    public boolean canWrite(RbelElement oldTargetElement) {
        return oldTargetElement.hasFacet(RbelHttpResponseFacet.class) || oldTargetElement.hasFacet(RbelHttpRequestFacet.class);
    }

    @Override
    public byte[] write(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, byte[] newContent) {
        Optional<RbelHttpResponseFacet> responseFacet = oldTargetElement.getFacet(RbelHttpResponseFacet.class);
        Optional<RbelHttpRequestFacet> requestFacet = oldTargetElement.getFacet(RbelHttpRequestFacet.class);
        RbelHttpMessageFacet messageFacet = oldTargetElement.getFacetOrFail(RbelHttpMessageFacet.class);
        StringJoiner joiner = new StringJoiner("\r\n");
        joiner.add(this.buildTitleLine(oldTargetModifiedChild, new String(newContent), responseFacet, requestFacet));
        byte[] body = (byte[])this.getChunkedMapper(oldTargetElement).apply(this.getBodyContent(messageFacet, oldTargetModifiedChild, newContent));
        if (messageFacet.getHeader() == oldTargetModifiedChild) {
            joiner.add(new String(newContent));
        } else {
            joiner.add(this.patchHeader(new String(messageFacet.getHeader().getRawContent()), body.length));
        }
        joiner.add("");
        joiner.add("");
        return ArrayUtils.addAll(joiner.toString().getBytes(StandardCharsets.UTF_8), body);
    }

    private UnaryOperator<byte[]> getChunkedMapper(RbelElement oldTargetElement) {
        if (this.isChunkedMessage(oldTargetElement)) {
            return array -> ArrayUtils.addAll((((byte[])array).length + "\r\n").getBytes(), ArrayUtils.addAll(array, "\r\n0\r\n".getBytes()));
        }
        return UnaryOperator.identity();
    }

    private boolean isChunkedMessage(RbelElement oldTargetElement) {
        return oldTargetElement.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getHeader).flatMap(el -> el.getFacet(RbelHttpHeaderFacet.class)).stream().flatMap(h2 -> h2.getCaseInsensitiveMatches("Transfer-Encoding")).map(RbelElement::getRawStringContent).filter(value -> value.equalsIgnoreCase("chunked")).findAny().isPresent();
    }

    private String patchHeader(String headerRaw, int length) {
        return Arrays.stream(headerRaw.split("\r\n")).map(headerLine -> {
            if (headerLine.toLowerCase(Locale.ROOT).startsWith("content-length")) {
                return "Content-Length: " + length;
            }
            return headerLine;
        }).collect(Collectors.joining("\r\n"));
    }

    private byte[] getBodyContent(RbelHttpMessageFacet messageFacet, RbelElement oldTargetModifiedChild, byte[] newContent) {
        if (messageFacet.getBody() == oldTargetModifiedChild) {
            return newContent;
        }
        return messageFacet.getBody().getRawContent();
    }

    private String buildTitleLine(RbelElement oldTargetModifiedChild, String newContent, Optional<RbelHttpResponseFacet> responseFacet, Optional<RbelHttpRequestFacet> requestFacet) {
        StringBuilder builder = new StringBuilder();
        if (requestFacet.isPresent()) {
            if (requestFacet.get().getMethod() == oldTargetModifiedChild) {
                builder.append(newContent);
            } else {
                builder.append(requestFacet.get().getMethod().getRawStringContent());
            }
            builder.append(" ");
            if (requestFacet.get().getPath() == oldTargetModifiedChild) {
                builder.append(newContent);
            } else {
                builder.append(requestFacet.get().getPath().getRawStringContent());
            }
            builder.append(" HTTP/1.1");
            return builder.toString();
        }
        if (responseFacet.get().getResponseCode() == oldTargetModifiedChild) {
            return "HTTP/1.1 " + newContent;
        }
        return "HTTP/1.1 " + responseFacet.get().getResponseCode().getRawStringContent();
    }
}

