/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data.facet;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelUriParameterFacet;
import de.gematik.rbellogger.renderer.RbelHtmlFacetRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class RbelUriFacet
implements RbelFacet {
    private final RbelElement basicPath;
    private final List<RbelElement> queryParameters;

    @Override
    public List<Map.Entry<String, RbelElement>> getChildElements() {
        ArrayList<Map.Entry<String, RbelElement>> result = new ArrayList<Map.Entry<String, RbelElement>>();
        result.addAll(this.queryParameters.stream().map(el -> Pair.of(el.getFacetOrFail(RbelUriParameterFacet.class).getKeyAsString(), el)).collect(Collectors.toList()));
        result.add(Pair.of("basicPath", this.basicPath));
        return result;
    }

    public String getBasicPathString() {
        return this.basicPath.seekValue(String.class).orElseThrow();
    }

    public Optional<RbelElement> getQueryParameter(String key) {
        Objects.requireNonNull(key);
        return this.queryParameters.stream().map(element -> element.getFacetOrFail(RbelUriParameterFacet.class)).filter(e -> e.getKeyAsString().equals(key)).map(RbelUriParameterFacet::getValue).findFirst();
    }

    @ConstructorProperties(value={"basicPath", "queryParameters"})
    @Generated
    RbelUriFacet(RbelElement basicPath, List<RbelElement> queryParameters) {
        this.basicPath = basicPath;
        this.queryParameters = queryParameters;
    }

    @Generated
    public static RbelUriFacetBuilder builder() {
        return new RbelUriFacetBuilder();
    }

    @Generated
    public RbelElement getBasicPath() {
        return this.basicPath;
    }

    @Generated
    public List<RbelElement> getQueryParameters() {
        return this.queryParameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelUriFacet)) {
            return false;
        }
        RbelUriFacet other = (RbelUriFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RbelElement this$basicPath = this.getBasicPath();
        RbelElement other$basicPath = other.getBasicPath();
        if (this$basicPath == null ? other$basicPath != null : !this$basicPath.equals(other$basicPath)) {
            return false;
        }
        List<RbelElement> this$queryParameters = this.getQueryParameters();
        List<RbelElement> other$queryParameters = other.getQueryParameters();
        return !(this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelUriFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RbelElement $basicPath = this.getBasicPath();
        result = result * 59 + ($basicPath == null ? 43 : $basicPath.hashCode());
        List<RbelElement> $queryParameters = this.getQueryParameters();
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelUriFacet(basicPath=" + this.getBasicPath() + ", queryParameters=" + this.getQueryParameters() + ")";
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHtmlFacetRenderer(){

            @Override
            public boolean checkForRendering(RbelElement element) {
                return element.hasFacet(RbelUriFacet.class);
            }

            @Override
            public ContainerTag performRendering(RbelElement element, Optional<String> key, RbelHtmlRenderingToolkit renderingToolkit) {
                RbelUriFacet uriFacet = element.getFacetOrFail(RbelUriFacet.class);
                String originalUrl = element.getRawStringContent();
                ContainerTag urlContent = this.renderUrlContent(renderingToolkit, uriFacet, originalUrl);
                DomContent note = RbelHtmlRenderingToolkit.addNote(element, new String[0]);
                if (element.traverseAndReturnNestedMembers().isEmpty()) {
                    return TagCreator.div().with((DomContent)urlContent).with(note);
                }
                return RbelHtmlRenderingToolkit.ancestorTitle().with((DomContent)RbelHtmlRenderingToolkit.vertParentTitle().with((DomContent)((ContainerTag)TagCreator.div().withClass("tile is-child pr-3")).with((DomContent)urlContent).with(note).with(renderingToolkit.convertNested(element))));
            }

            private ContainerTag renderUrlContent(RbelHtmlRenderingToolkit renderingToolkit, RbelUriFacet uriFacet, String originalUrl) {
                if (!originalUrl.contains("?")) {
                    return TagCreator.div(new UnescapedText(originalUrl));
                }
                ContainerTag div = TagCreator.div(uriFacet.getBasicPathString() + "?").with((DomContent)TagCreator.br());
                boolean firstElement = true;
                for (RbelElement queryElementEntry : uriFacet.getQueryParameters()) {
                    RbelUriParameterFacet parameterFacet = queryElementEntry.getFacetOrFail(RbelUriParameterFacet.class);
                    String shadedStringContent = renderingToolkit.shadeValue(parameterFacet.getValue(), Optional.of(parameterFacet.getKeyAsString())).map(content -> queryElementEntry.getKey() + "=" + content).orElse(queryElementEntry.getRawStringContent());
                    div.with((DomContent)TagCreator.div((firstElement ? "" : "&") + shadedStringContent).with(RbelHtmlRenderingToolkit.addNote(queryElementEntry, " ml-6")));
                    firstElement = false;
                }
                return div;
            }
        });
    }

    @Generated
    public static class RbelUriFacetBuilder {
        @Generated
        private RbelElement basicPath;
        @Generated
        private List<RbelElement> queryParameters;

        @Generated
        RbelUriFacetBuilder() {
        }

        @Generated
        public RbelUriFacetBuilder basicPath(RbelElement basicPath) {
            this.basicPath = basicPath;
            return this;
        }

        @Generated
        public RbelUriFacetBuilder queryParameters(List<RbelElement> queryParameters) {
            this.queryParameters = queryParameters;
            return this;
        }

        @Generated
        public RbelUriFacet build() {
            return new RbelUriFacet(this.basicPath, this.queryParameters);
        }

        @Generated
        public String toString() {
            return "RbelUriFacet.RbelUriFacetBuilder(basicPath=" + this.basicPath + ", queryParameters=" + this.queryParameters + ")";
        }
    }
}

