/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelRootFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.util.RbelException;
import de.gematik.rbellogger.util.RbelPathExecutor;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelElement {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelElement.class);
    private final String uuid = UUID.randomUUID().toString();
    private final byte[] rawContent;
    private final transient RbelElement parentNode;
    private final List<RbelFacet> facets = new ArrayList<RbelFacet>();
    private final AtomicReference<String> note = new AtomicReference();

    public static RbelElement wrap(byte[] rawValue, RbelElement parentNode, Object value) {
        return new RbelElement(rawValue, parentNode).addFacet(new RbelValueFacet<Object>(value));
    }

    public static RbelElement wrap(RbelElement parentNode, Object value) {
        return new RbelElement(value.toString().getBytes(), parentNode).addFacet(new RbelValueFacet<Object>(value));
    }

    public Optional<String> getNote() {
        return Optional.ofNullable(this.note.get());
    }

    public RbelElement setNote(String value) {
        this.note.set(value);
        return this;
    }

    public <T> Optional<T> getFacet(Class<T> clazz) {
        return this.facets.stream().filter(facet -> clazz.isAssignableFrom(facet.getClass())).map(clazz::cast).findFirst();
    }

    public <T extends RbelFacet> boolean hasFacet(Class<T> clazz) {
        return this.getFacet(clazz).isPresent();
    }

    public RbelElement addFacet(RbelFacet facet) {
        if (this.hasFacet(facet.getClass())) {
            throw new RbelException("Trying to re-add facet " + facet.getClass().getSimpleName() + "! (" + facet + ")");
        }
        this.facets.add(facet);
        return this;
    }

    public List<? extends RbelElement> getChildNodes() {
        return this.facets.stream().map(RbelFacet::getChildElements).flatMap(Collection::stream).map(Map.Entry::getValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Map.Entry<String, RbelElement>> getChildNodesWithKey() {
        return this.facets.stream().map(RbelFacet::getChildElements).flatMap(Collection::stream).filter(el -> el.getValue() != null).collect(Collectors.toList());
    }

    public void triggerPostConversionListener(RbelConverter context) {
        for (RbelElement rbelElement : this.getChildNodes()) {
            rbelElement.triggerPostConversionListener(context);
        }
        context.triggerPostConversionListenerFor(this);
    }

    public List<RbelElement> traverseAndReturnNestedMembers() {
        return this.getChildNodes().stream().map(RbelElement::traverseAndReturnNestedMembersInternal).flatMap(Collection::stream).collect(Collectors.toList());
    }

    List<RbelElement> traverseAndReturnNestedMembersInternal() {
        log.trace("Traversing into {}: facets are {}", (Object)this.findNodePath(), (Object)this.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.toList()));
        if (this.hasFacet(RbelRootFacet.class)) {
            return List.of(this);
        }
        return this.getChildNodes().stream().map(child -> child.traverseAndReturnNestedMembersInternal()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isStructuralHelperElement() {
        return false;
    }

    public String findNodePath() {
        LinkedList<Optional<String>> keyList = new LinkedList<Optional<String>>();
        AtomicReference<RbelElement> ptr = new AtomicReference<RbelElement>(this);
        while (ptr.get().getParentNode() != null) {
            keyList.addFirst(ptr.get().getParentNode().getChildNodesWithKey().stream().filter(entry -> entry.getValue() == ptr.get()).map(Map.Entry::getKey).findFirst());
            ptr.set(ptr.get().getParentNode());
        }
        return keyList.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.joining("."));
    }

    public Optional<RbelElement> getFirst(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).findFirst();
    }

    public List<RbelElement> getAll(String key) {
        return this.getChildNodesWithKey().stream().filter(entry -> ((String)entry.getKey()).equals(key)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public Optional<String> findKeyInParentElement() {
        return Optional.of(this).map(RbelElement::getParentNode).filter(Objects::nonNull).stream().flatMap(parent -> parent.getChildNodesWithKey().stream()).filter(e -> e.getValue() == this).map(Map.Entry::getKey).findFirst();
    }

    public List<RbelElement> findRbelPathMembers(String rbelPath) {
        return new RbelPathExecutor(this, rbelPath).execute();
    }

    public boolean isSimpleElement() {
        return false;
    }

    public String getRawStringContent() {
        if (this.rawContent == null) {
            return null;
        }
        return new String(this.rawContent);
    }

    public <T extends RbelFacet> T getFacetOrFail(Class<T> facetClass) {
        return (T)((RbelFacet)this.getFacet(facetClass).orElseThrow());
    }

    public String toString() {
        return new ToStringBuilder(this).append("uuid", this.uuid).append("facets", this.facets).append("note", this.note).append("path", this.findNodePath()).toString();
    }

    public Optional<Object> seekValue() {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).filter(Objects::nonNull);
    }

    public <T> Optional<T> seekValue(Class<T> clazz) {
        return this.getFacet(RbelValueFacet.class).map(RbelValueFacet::getValue).filter(Objects::nonNull).filter(clazz::isInstance).map(clazz::cast);
    }

    public Optional<String> getKey() {
        if (this.parentNode == null) {
            return Optional.empty();
        }
        for (Map.Entry<String, RbelElement> ptr : this.parentNode.getChildNodesWithKey()) {
            if (ptr.getValue() != this) continue;
            return Optional.ofNullable(ptr.getKey());
        }
        throw new RbelException("Unable to find key for element " + this);
    }

    public void addOrReplaceFacet(RbelFacet facet) {
        if (this.hasFacet(facet.getClass())) {
            this.facets.remove(this.getFacet(facet.getClass()).get());
        }
        this.facets.add(facet);
    }

    public Optional<RbelElement> findElement(String rbelPath) {
        List<RbelElement> resultList = this.findRbelPathMembers(rbelPath);
        if (resultList.isEmpty()) {
            return Optional.empty();
        }
        if (resultList.size() == 1) {
            return Optional.of(resultList.get(0));
        }
        throw new RbelPathNotUniqueException("RbelPath '" + rbelPath + "' is not unique! Found " + resultList.size() + " elements, expected only one!");
    }

    public String printTreeStructure() {
        return RbelElementTreePrinter.builder().rootElement(this).build().execute();
    }

    public String printTreeStructure(int maximumLevels, boolean printKeys) {
        return RbelElementTreePrinter.builder().rootElement(this).printKeys(printKeys).maximumLevels(maximumLevels).build().execute();
    }

    @Generated
    public static RbelElementBuilder builder() {
        return new RbelElementBuilder();
    }

    @Generated
    public RbelElementBuilder toBuilder() {
        return new RbelElementBuilder().rawContent(this.rawContent).parentNode(this.parentNode);
    }

    @ConstructorProperties(value={"rawContent", "parentNode"})
    @Generated
    public RbelElement(byte[] rawContent, RbelElement parentNode) {
        this.rawContent = rawContent;
        this.parentNode = parentNode;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public byte[] getRawContent() {
        return this.rawContent;
    }

    @Generated
    public RbelElement getParentNode() {
        return this.parentNode;
    }

    @Generated
    public List<RbelFacet> getFacets() {
        return this.facets;
    }

    @Generated
    public static class RbelElementBuilder {
        @Generated
        private byte[] rawContent;
        @Generated
        private RbelElement parentNode;

        @Generated
        RbelElementBuilder() {
        }

        @Generated
        public RbelElementBuilder rawContent(byte[] rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        @Generated
        public RbelElementBuilder parentNode(RbelElement parentNode) {
            this.parentNode = parentNode;
            return this;
        }

        @Generated
        public RbelElement build() {
            return new RbelElement(this.rawContent, this.parentNode);
        }

        @Generated
        public String toString() {
            return "RbelElement.RbelElementBuilder(rawContent=" + Arrays.toString(this.rawContent) + ", parentNode=" + this.parentNode + ")";
        }
    }

    private class RbelPathNotUniqueException
    extends RuntimeException {
        public RbelPathNotUniqueException(String s2) {
            super(s2);
        }
    }
}

