/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.modifier;

import de.gematik.rbellogger.converter.brainpool.BrainpoolCurves;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.elements.RbelJwtSignature;
import de.gematik.rbellogger.data.facet.RbelJwtFacet;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.key.RbelKeyManager;
import de.gematik.rbellogger.modifier.RbelElementWriter;
import de.gematik.rbellogger.util.JsonUtils;
import java.beans.ConstructorProperties;
import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class RbelJwtWriter
implements RbelElementWriter {
    private final RbelKeyManager rbelKeyManager;

    @Override
    public boolean canWrite(RbelElement oldTargetElement) {
        return oldTargetElement.hasFacet(RbelJwtFacet.class);
    }

    @Override
    public String write(RbelElement oldTargetElement, RbelElement oldTargetModifiedChild, String newContent) {
        RbelJwtFacet jwtFacet = oldTargetElement.getFacetOrFail(RbelJwtFacet.class);
        return this.createUpdatedJws(oldTargetModifiedChild, newContent, jwtFacet);
    }

    private String createUpdatedJws(RbelElement oldTargetModifiedChild, String newContent, RbelJwtFacet jwtFacet) {
        JsonWebSignature jws = new JsonWebSignature();
        this.writeHeaderInJws(oldTargetModifiedChild, newContent, jwtFacet, jws);
        jws.setPayload(this.extractJwsBodyClaims(oldTargetModifiedChild, newContent, jwtFacet));
        jws.setKey(this.extractJwsKey(jwtFacet, jws));
        if (!jwtFacet.getSignature().getFacetOrFail(RbelJwtSignature.class).isValid()) {
            throw new InvalidJwtSignatureException("The signature is invalid\n" + jwtFacet.getSignature().printTreeStructure());
        }
        try {
            return jws.getCompactSerialization();
        }
        catch (JoseException e) {
            throw new JwtUpdateException("Error writing into Jwt", e);
        }
    }

    private Key extractJwsKey(RbelJwtFacet jwtFacet, JsonWebSignature jsonWebSignature) {
        return (Key)jwtFacet.getSignature().getFacet(RbelJwtSignature.class).map(RbelJwtSignature::getVerifiedUsing).filter(obj -> Objects.nonNull(obj)).flatMap(verifiedUsing -> verifiedUsing.seekValue(String.class)).flatMap(this.rbelKeyManager::findKeyByName).flatMap(this::getKeyBasedOnEncryptionType).orElseThrow(() -> new InvalidJwtSignatureException("Could not find the key matching signature \n" + jwtFacet.getSignature().printTreeStructure()));
    }

    private void writeHeaderInJws(RbelElement oldTargetModifiedChild, String newContent, RbelJwtFacet jwtFacet, JsonWebSignature jws) {
        this.extractJwtHeaderClaims(oldTargetModifiedChild, newContent, jwtFacet).forEach(pair -> jws.setHeader((String)pair.getKey(), (String)pair.getValue()));
    }

    private List<Map.Entry<String, String>> extractJwtHeaderClaims(RbelElement oldTargetModifiedChild, String newContent, RbelJwtFacet jwtFacet) {
        if (jwtFacet.getHeader() == oldTargetModifiedChild) {
            return JsonUtils.convertJsonObjectStringToMap(newContent);
        }
        return JsonUtils.convertJsonObjectStringToMap(jwtFacet.getHeader().getRawStringContent());
    }

    private String extractJwsBodyClaims(RbelElement oldTargetModifiedChild, String newContent, RbelJwtFacet jwtFacet) {
        if (jwtFacet.getBody() == oldTargetModifiedChild) {
            return newContent;
        }
        return jwtFacet.getBody().getRawStringContent();
    }

    private Optional<Key> getKeyBasedOnEncryptionType(RbelKey rbelKey) {
        if (rbelKey.getKey().getAlgorithm().equals("HS256") || rbelKey.getKey().getAlgorithm().equals("HS512") || rbelKey.getKey().getAlgorithm().equals("HS384")) {
            return Optional.ofNullable(rbelKey.getKey());
        }
        return this.rbelKeyManager.findCorrespondingPrivateKey(rbelKey.getKeyName()).map(RbelKey::getKey);
    }

    @ConstructorProperties(value={"rbelKeyManager"})
    @Generated
    public RbelJwtWriter(RbelKeyManager rbelKeyManager) {
        this.rbelKeyManager = rbelKeyManager;
    }

    static {
        BrainpoolCurves.init();
    }

    public class InvalidJwtSignatureException
    extends RuntimeException {
        public InvalidJwtSignatureException(String s) {
            super(s);
        }
    }

    public class JwtUpdateException
    extends RuntimeException {
        public JwtUpdateException(String s, JoseException e) {
            super(s, e);
        }
    }
}

