/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.jnetpcap.util.JLogger;
import org.jnetpcap.util.config.ConfigString;
import org.jnetpcap.util.config.JConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchpathString
extends ConfigString {
    private static final Logger logger = JLogger.getLogger(JConfig.class);
    private final List<String> pathContents = new ArrayList<String>();
    private final Properties properties;
    private final Map<String, String> variables;

    public SearchpathString(String string, Map<String, String> map, Properties properties) {
        super(string, map, properties);
        this.variables = map;
        this.properties = properties;
    }

    private void cleanupString() {
        super.expand("", this.variables, this.properties);
        this.remove("\\\r\n");
        this.trimToSize();
        this.start = 0;
        this.end = -1;
    }

    @Override
    public SearchpathString reset() {
        super.reset();
        this.pathContents.clear();
        return this;
    }

    private boolean splitToComponents() {
        while (this.scanNext("'", "'", this.end + 1) && this.start != -1) {
            if (this.properties == null) {
                return false;
            }
            String string = this.substring(this.start + 1, this.end).trim();
            if (string.length() == 0) continue;
            this.pathContents.add(string);
        }
        return this.start == -1;
    }

    public JConfig.SearchPath[] toArray() {
        this.reset();
        this.cleanupString();
        this.splitToComponents();
        ArrayList<JConfig.SearchPath> arrayList = new ArrayList<JConfig.SearchPath>(this.pathContents.size());
        for (String string : this.pathContents) {
            String string2;
            if (string.startsWith("File(")) {
                string2 = string.substring("File(".length(), string.length() - 1);
                arrayList.add(new JConfig.FilesystemSearch(new ConfigString(string2, this.variables, this.properties)));
                continue;
            }
            if (string.startsWith("Classpath(")) {
                string2 = string.substring("Classpath(".length(), string.length() - 1);
                arrayList.add(new JConfig.ClasspathSearch(new ConfigString(string2, this.variables, this.properties)));
                continue;
            }
            if (string.startsWith("URL(")) {
                string2 = string.substring("URL(".length(), string.length() - 1);
                arrayList.add(new JConfig.URLSearch(new ConfigString(string2, this.variables, this.properties)));
                continue;
            }
            logger.warning("unexpected search component type " + string);
        }
        return arrayList.toArray(new JConfig.SearchPath[arrayList.size()]);
    }
}

