/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util.config;

import java.util.Map;
import java.util.Properties;
import org.jnetpcap.util.ExpandableString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigString
extends ExpandableString {
    private static final String VO = "${";
    private static final String VC = "}";
    private static final String PO = "@{";
    private static final String PC = "}";
    private final Map<String, String> variables;
    private final Properties properties;

    public ConfigString(String string, Map<String, String> map, Properties properties) {
        super(string);
        this.variables = map;
        this.properties = properties;
    }

    public boolean expand(String string) {
        return this.expand(string, this.variables, this.properties);
    }

    public boolean expand(String string, Map<String, String> map) {
        return this.expand(string, map, this.properties);
    }

    public boolean expand(String string, Map<String, String> map, Properties properties) {
        if (!this.saveQuotes()) {
            return false;
        }
        this.count = 0;
        while (this.expandVariables(string, map, properties) && this.expandProperties(string, map, properties)) {
            if (this.count == 0) {
                this.restoreQuotes();
                return true;
            }
            this.count = 0;
        }
        this.restoreQuotes();
        return false;
    }

    public boolean expand(String string, Properties properties) {
        return this.expand(string, null, properties);
    }

    public boolean expandProperties(String string, Map<String, String> map, Properties properties) {
        while (this.scanNext(PO, "}") && this.start != -1) {
            if (properties == null) {
                return false;
            }
            String string2 = super.substring(this.start + PO.length(), this.end);
            String string3 = properties.getProperty(string2);
            if (string3 == null) {
                return false;
            }
            super.replace(this.start, this.end + "}".length(), string3);
            if (!this.saveQuotes()) {
                return false;
            }
            if (this.expandVariables(string, map, properties)) continue;
            return false;
        }
        return this.start == -1;
    }

    public boolean expandVariables(String string, Map<String, String> map, Properties properties) {
        while (this.scanNext(VO, "}") && this.start != -1) {
            String string2 = super.substring(this.start + VO.length(), this.end);
            if (string2.equals("name")) {
                super.replace(this.start, this.end + "}".length(), string);
                continue;
            }
            if (map != null && map.containsKey(string2)) {
                super.replace(this.start, this.end + 1, map.get(string2));
                continue;
            }
            return false;
        }
        return this.start == -1;
    }

    @Override
    public ConfigString reset() {
        super.reset();
        return this;
    }
}

