/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.sigtran;

import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.ProtocolSuite;
import org.jnetpcap.util.checksum.Checksum;

@Header(length=12, suite=ProtocolSuite.SIGTRAN, description="Stream Control Transmission Protocol")
public class Sctp
extends JHeader
implements JHeaderChecksum {
    public static final int ID = 32;

    @Field(format="%d", offset=0, length=16)
    public int source() {
        return super.getUShort(0);
    }

    public void source(int n) {
        super.setUShort(0, n);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String sourceDescription() {
        switch (this.source()) {
            case 80: 
            case 8080: 
            case 8081: {
                return "HTTP";
            }
            case 3868: {
                return "DIAMETER";
            }
        }
        return null;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String destinationDescription() {
        switch (this.destination()) {
            case 80: 
            case 8080: 
            case 8081: {
                return "HTTP";
            }
            case 3868: {
                return "DIAMETER";
            }
        }
        return null;
    }

    @Field(format="%d", offset=16, length=16)
    public int destination() {
        return super.getUShort(2);
    }

    public void destination(int n) {
        super.setUShort(2, n);
    }

    @Field(format="%x", offset=32, length=32)
    public long tag() {
        return super.getUInt(4);
    }

    public void tag(long l) {
        super.setUInt(4, l);
    }

    @Field(offset=64, length=32, format="%x", name="checksum")
    public int checksum() {
        return super.getInt(8);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        long l = this.calculateChecksum();
        if ((long)this.checksum() == l) {
            return "correct";
        }
        return "incorrect: 0x" + Long.toHexString(l).toUpperCase();
    }

    public int calculateChecksum() {
        JPacket jPacket = this.getPacket();
        int n = this.checksum();
        this.checksum(0);
        int n2 = Checksum.sctp(jPacket, this.getOffset(), this.getHeaderLength() + this.getPayloadLength());
        this.checksum(n);
        return n2;
    }

    public boolean checksum(int n) {
        super.setUInt(8, n);
        return true;
    }

    public boolean isChecksumValid() {
        return this.checksum() == this.calculateChecksum();
    }

    public boolean recalculateChecksum() {
        return this.checksum(this.calculateChecksum());
    }
}

