/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.format;

import java.util.ArrayList;
import java.util.List;
import org.jnetpcap.packet.JPacket;

public class FormatUtils {
    private static final int DAY_MILLIS = 86400000;
    private static final int HOUR_MILLIS = 3600000;
    private static final int MINUTE_MILLIS = 60000;
    private static final List<String> multiLineStringList = new ArrayList<String>();
    private static final int SECOND_MILLIS = 1000;
    private static String SPACE_CHAR = " ";
    static String[] table = new String[256];
    private static final int WEEK_MILLIS = 604800000;

    private static void initTable1char() {
        int n;
        for (n = 0; n < 31; ++n) {
            FormatUtils.table[n] = ".";
        }
        for (n = 31; n < 127; ++n) {
            FormatUtils.table[n] = new String(new byte[]{(byte)n});
        }
        for (n = 127; n < 256; ++n) {
            FormatUtils.table[n] = ".";
        }
    }

    private static void initTable3chars() {
        int n;
        for (n = 0; n < 31; ++n) {
            FormatUtils.table[n] = "\\" + Integer.toHexString(n);
            if (table[n].length() != 2) continue;
            int n2 = n;
            table[n2] = table[n2] + " ";
        }
        for (n = 31; n < 127; ++n) {
            FormatUtils.table[n] = new String(new byte[]{(byte)n, 32, 32});
        }
        for (n = 127; n < 256; ++n) {
            FormatUtils.table[n] = "\\" + Integer.toHexString(n);
            if (table[n].length() != 2) continue;
            int n3 = n;
            table[n3] = table[n3] + " ";
        }
        FormatUtils.table[0] = "\\0 ";
        FormatUtils.table[7] = "\\a ";
        FormatUtils.table[11] = "\\v ";
        FormatUtils.table[8] = "\\b ";
        FormatUtils.table[9] = "\\t ";
        FormatUtils.table[10] = "\\n ";
        FormatUtils.table[12] = "\\f ";
        FormatUtils.table[13] = "\\r ";
    }

    public static String asString(byte[] byArray) {
        return FormatUtils.asString(byArray, ':');
    }

    public static String asString(byte[] byArray, char c) {
        return FormatUtils.asString(byArray, c, 16);
    }

    public static String asString(byte[] byArray, char c, int n) {
        return FormatUtils.asString(byArray, c, n, 0, byArray.length);
    }

    public static String asString(byte[] byArray, char c, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < n2 + n3; ++i) {
            int n4 = byArray[i];
            if (stringBuilder.length() != 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(Integer.toString(n4 < 0 ? n4 + 256 : n4, n).toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static String asStringZeroPad(byte[] byArray, char c, int n, int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n2; i < n2 + n3; ++i) {
            String string;
            int n4 = byArray[i];
            if (stringBuilder.length() != 0) {
                stringBuilder.append(c);
            }
            if ((string = Integer.toString(n4 < 0 ? n4 + 256 : n4, n).toUpperCase()).length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String ip(byte[] byArray) {
        if (byArray.length == 4) {
            return FormatUtils.asString(byArray, '.', 10);
        }
        return FormatUtils.asStringIp6(byArray, true);
    }

    public static String mac(byte[] byArray) {
        return FormatUtils.asStringZeroPad(byArray, ':', 16, 0, byArray.length);
    }

    public static String asStringIp6(byte[] byArray, boolean bl) {
        int n;
        if (byArray.length != 16) {
            throw new IllegalArgumentException("expecting 16 byte ip6 address array");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        int n3 = -1;
        for (n = 0; n < byArray.length && bl; ++n) {
            if (n % 2 == 0 && byArray[n] == 0 && byArray[n + 1] == 0 && n2 == 0) {
                n3 = n;
            }
            if (byArray[++n] != 0 && (n2 += 2) != 0) break;
        }
        if (n3 != -1 && n3 % 2 == 1) {
            ++n3;
            --n2;
        }
        if (n3 != -1 && n2 % 2 == 1) {
            --n2;
        }
        for (n = 0; n < byArray.length; ++n) {
            if (n == n3) {
                stringBuilder.append(':');
                if ((n += n2 - 1) != byArray.length - 1) continue;
                stringBuilder.append(':');
                continue;
            }
            int n4 = byArray[n];
            if (stringBuilder.length() != 0 && n % 2 == 0) {
                stringBuilder.append(':');
            }
            if (n4 >= 0 && n4 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n4 < 0 ? n4 + 256 : n4).toUpperCase());
        }
        return stringBuilder.toString();
    }

    public static String formatTimeInMillis(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = 0L;
        while (l > 0L) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            if (l > 604800000L) {
                l2 = l / 604800000L;
                stringBuilder.append(l2).append(' ').append(l2 > 1L ? "weeks" : "week");
                l -= l2 * 604800000L;
                continue;
            }
            if (l > 86400000L) {
                l2 = l / 86400000L;
                stringBuilder.append(l2).append(' ').append(l2 > 1L ? "days" : "day");
                l -= l2 * 86400000L;
                continue;
            }
            if (l > 3600000L) {
                l2 = l / 3600000L;
                stringBuilder.append(l2).append(' ').append(l2 > 1L ? "days" : "day");
                l -= l2 * 3600000L;
                continue;
            }
            if (l > 60000L) {
                l2 = l / 60000L;
                stringBuilder.append(l2).append(' ').append(l2 > 1L ? "minutes" : "minute");
                l -= l2 * 60000L;
                continue;
            }
            if (l > 1000L) {
                l2 = l / 1000L;
                stringBuilder.append(l2).append(' ').append(l2 > 1L ? "seconds" : "second");
                l -= l2 * 1000L;
                continue;
            }
            if (l <= 0L) continue;
            l2 = l;
            stringBuilder.append(l2).append(' ').append(l2 > 1L ? "millis" : "milli");
            l -= l2;
        }
        return stringBuilder.toString();
    }

    public static String[] hexdump(byte[] byArray, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return FormatUtils.hexdump(byArray, n, n2, bl, bl2, bl3, null);
    }

    public static int[][] markers(JPacket.State state) {
        int[][] nArray = new int[state.getHeaderCount() + 1][2];
        nArray[0][0] = -1;
        nArray[0][1] = -1;
        for (int i = 0; i < state.getHeaderCount(); ++i) {
            nArray[i + 1][0] = state.getHeaderOffsetByIndex(i);
            nArray[i + 1][1] = state.getHeaderLengthByIndex(i);
        }
        return nArray;
    }

    public static String[] hexdump(byte[] byArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, int[][] nArray) {
        multiLineStringList.clear();
        int n3 = 0;
        while (n3 + n2 < byArray.length) {
            multiLineStringList.add(FormatUtils.hexLine(byArray, n3 + n, n3 + n2, bl, bl2, bl3, nArray));
            n3 += 16;
        }
        return multiLineStringList.toArray(new String[multiLineStringList.size()]);
    }

    public static String hexdump(byte[] byArray) {
        return FormatUtils.hexdumpCombined(byArray, 0, 0, true, true, true);
    }

    public static String hexdump(JPacket jPacket) {
        return FormatUtils.hexdump(jPacket.getByteArray(0, jPacket.size()), jPacket.getState());
    }

    public static String hexdump(byte[] byArray, JPacket.State state) {
        return FormatUtils.hexdumpCombined(byArray, 0, 0, true, true, true, FormatUtils.markers(state));
    }

    public static String hexdumpCombined(byte[] byArray, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        return FormatUtils.hexdumpCombined(byArray, n, n2, bl, bl2, bl3, null);
    }

    public static String hexdumpCombined(byte[] byArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, int[][] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : FormatUtils.hexdump(byArray, n, n2, bl, bl2, bl3, nArray)) {
            stringBuilder.append(string).append('\n');
        }
        return stringBuilder.toString();
    }

    public static String hexLine(byte[] byArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, int[][] nArray) {
        String string = "";
        if (bl) {
            string = string + FormatUtils.hexLineAddress(n);
            string = string + ":";
        }
        if (bl3) {
            string = string + FormatUtils.hexLineData(byArray, n2, nArray);
        }
        if (bl2) {
            string = string + SPACE_CHAR;
            string = string + SPACE_CHAR;
            string = string + SPACE_CHAR;
            string = string + FormatUtils.hexLineText(byArray, n2);
        }
        return string;
    }

    public static String hexLineAddress(int n) {
        String string = "";
        string = Integer.toHexString(n);
        for (int i = string.length(); i < 4; ++i) {
            string = "0" + string;
        }
        return string;
    }

    public static String hexLineData(byte[] byArray, int n) {
        String string = "";
        int n2 = 0;
        for (n2 = 0; n2 + n < byArray.length && n2 < 16; ++n2) {
            int n3 = n2 + n;
            if (n2 == 0) {
                string = string + SPACE_CHAR;
            }
            if (n2 % 4 == 0 && n2 != 0) {
                string = string + SPACE_CHAR;
            }
            string = string + FormatUtils.toHexString(byArray[n3]) + SPACE_CHAR;
        }
        while (n2 < 16) {
            if (n2 % 4 == 0 && n2 != 0) {
                string = string + SPACE_CHAR;
            }
            string = string + SPACE_CHAR + SPACE_CHAR + SPACE_CHAR;
            ++n2;
        }
        return string;
    }

    public static String hexLineStream(byte[] byArray, int n) {
        String string = "";
        int n2 = 0;
        n2 = 0;
        while (n2 + n < byArray.length) {
            int n3 = n2 + n;
            string = string + FormatUtils.toHexString(byArray[n3]);
            ++n2;
        }
        return string;
    }

    public static String hexLineData(byte[] byArray, int n, int[][] nArray) {
        if (nArray == null) {
            return FormatUtils.hexLineData(byArray, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray = new String[]{"*", "*"};
        int n2 = FormatUtils.findMarker(nArray, n);
        int n3 = nArray[n2][0];
        int n4 = n3 + nArray[n2][1] - 1;
        int n5 = 0;
        for (n5 = 0; n5 + n < byArray.length && n5 < 16; ++n5) {
            int n6 = n5 + n;
            if (n6 == 0 && n6 == n3) {
                stringBuilder.append(stringArray[n2 % 2]);
            } else if (n5 == 0) {
                stringBuilder.append(SPACE_CHAR);
            }
            if (n5 % 4 == 0 && n5 != 0) {
                stringBuilder.append(SPACE_CHAR);
            }
            if (n6 == n4) {
                n2 = FormatUtils.findMarker(nArray, n6 + 1);
                n3 = nArray[n2][0];
                n4 = n3 + nArray[n2][1] - 1;
                stringBuilder.append(FormatUtils.toHexString(byArray[n6])).append(stringArray[n2 % 2]);
                continue;
            }
            stringBuilder.append(FormatUtils.toHexString(byArray[n6])).append(SPACE_CHAR);
        }
        while (n5 < 16) {
            if (n5 % 4 == 0 && n5 != 0) {
                stringBuilder.append(SPACE_CHAR);
            }
            stringBuilder.append(SPACE_CHAR).append(SPACE_CHAR).append(SPACE_CHAR);
            ++n5;
        }
        return stringBuilder.toString();
    }

    private static int findMarker(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i][0];
            int n3 = n2 + nArray[i][1] - 1;
            if (n < n2 || n >= n3) continue;
            return i;
        }
        return 0;
    }

    public static String hexLineText(byte[] byArray, int n) {
        int n2;
        String string = "";
        for (n2 = 0; n2 + n < byArray.length && n2 < 16; ++n2) {
            string = string + table[byArray[n2 + n] & 0xFF];
        }
        while (n2 < 16) {
            string = string + SPACE_CHAR;
            ++n2;
        }
        return string;
    }

    public static byte[] toByteArray(String string) {
        String string2 = string.replaceAll(" |\n", "");
        byte[] byArray = new byte[string2.length() / 2];
        if (string2.length() % 2 != 0) {
            System.err.println(string2);
            throw new IllegalArgumentException("need even number of hex double digits [" + string2.length() + "]");
        }
        for (int i = 0; i < string2.length(); i += 2) {
            String string3 = string2.substring(i, i + 2);
            byArray[i / 2] = (byte)Integer.parseInt(string3, 16);
        }
        return byArray;
    }

    public static String toHexString(byte by) {
        String string = Integer.toHexString(by & 0xFF);
        if (string.length() == 1) {
            return "0" + string;
        }
        return string;
    }

    static {
        FormatUtils.initTable1char();
    }
}

