/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.util;

import java.util.Arrays;
import lombok.Generated;

public class RbelArrayUtils {
    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (array == prefix) {
            return true;
        }
        if (array == null || prefix == null) {
            return false;
        }
        int prefixLength = prefix.length;
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefixLength; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] sliceArrayAtMarker(byte[] array, byte[] marker, int searchOffset) {
        if (array == marker || array == null || marker == null) {
            throw new IllegalArgumentException();
        }
        int markerLength = marker.length;
        if (markerLength > array.length) {
            throw new IllegalArgumentException();
        }
        int indexOf = RbelArrayUtils.indexOf(array, marker, searchOffset);
        return Arrays.copyOfRange(array, indexOf, indexOf + markerLength);
    }

    public static int indexOf(byte[] outerArray, byte[] smallerArray, int searchOffset) {
        for (int i = searchOffset; i < outerArray.length - smallerArray.length + 1; ++i) {
            boolean found = true;
            for (int j = 0; j < smallerArray.length; ++j) {
                if (outerArray[i + j] == smallerArray[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return i;
        }
        return -1;
    }

    @Generated
    private RbelArrayUtils() {
    }
}

