/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.rbellogger.data;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHttpMessageRenderer;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class RbelTcpIpMessageFacet
implements RbelFacet {
    private final long sequenceNumber;
    private final RbelElement sender;
    private final RbelElement receiver;

    @Override
    public List<Map.Entry<String, RbelElement>> getChildElements() {
        return List.of(Pair.of("sender", this.sender), Pair.of("receiver", this.receiver));
    }

    public RbelHostname getSenderHostname() {
        return this.sender.getFacetOrFail(RbelHostnameFacet.class).toRbelHostname();
    }

    public RbelHostname getReceiverHostname() {
        return this.receiver.getFacetOrFail(RbelHostnameFacet.class).toRbelHostname();
    }

    @Generated
    public static RbelTcpIpMessageFacetBuilder builder() {
        return new RbelTcpIpMessageFacetBuilder();
    }

    @Generated
    public RbelTcpIpMessageFacetBuilder toBuilder() {
        return new RbelTcpIpMessageFacetBuilder().sequenceNumber(this.sequenceNumber).sender(this.sender).receiver(this.receiver);
    }

    @Generated
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Generated
    public RbelElement getSender() {
        return this.sender;
    }

    @Generated
    public RbelElement getReceiver() {
        return this.receiver;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RbelTcpIpMessageFacet)) {
            return false;
        }
        RbelTcpIpMessageFacet other = (RbelTcpIpMessageFacet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        RbelElement this$sender = this.getSender();
        RbelElement other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) {
            return false;
        }
        RbelElement this$receiver = this.getReceiver();
        RbelElement other$receiver = other.getReceiver();
        return !(this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RbelTcpIpMessageFacet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        RbelElement $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : $sender.hashCode());
        RbelElement $receiver = this.getReceiver();
        result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RbelTcpIpMessageFacet(sequenceNumber=" + this.getSequenceNumber() + ", sender=" + this.getSender() + ", receiver=" + this.getReceiver() + ")";
    }

    @ConstructorProperties(value={"sequenceNumber", "sender", "receiver"})
    @Generated
    public RbelTcpIpMessageFacet(long sequenceNumber, RbelElement sender, RbelElement receiver) {
        this.sequenceNumber = sequenceNumber;
        this.sender = sender;
        this.receiver = receiver;
    }

    static {
        RbelHtmlRenderer.registerFacetRenderer(new RbelHttpMessageRenderer());
    }

    @Generated
    public static class RbelTcpIpMessageFacetBuilder {
        @Generated
        private long sequenceNumber;
        @Generated
        private RbelElement sender;
        @Generated
        private RbelElement receiver;

        @Generated
        RbelTcpIpMessageFacetBuilder() {
        }

        @Generated
        public RbelTcpIpMessageFacetBuilder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        @Generated
        public RbelTcpIpMessageFacetBuilder sender(RbelElement sender) {
            this.sender = sender;
            return this;
        }

        @Generated
        public RbelTcpIpMessageFacetBuilder receiver(RbelElement receiver) {
            this.receiver = receiver;
            return this;
        }

        @Generated
        public RbelTcpIpMessageFacet build() {
            return new RbelTcpIpMessageFacet(this.sequenceNumber, this.sender, this.receiver);
        }

        @Generated
        public String toString() {
            return "RbelTcpIpMessageFacet.RbelTcpIpMessageFacetBuilder(sequenceNumber=" + this.sequenceNumber + ", sender=" + this.sender + ", receiver=" + this.receiver + ")";
        }
    }
}

